# XmlListModel

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## XmlListmodel

При работе с веб-ресурсами нередко применяется формат XML. 
Он используется в таких вещах, как RSS, различных подкастах.
Значит, у нас появляется задача получить этот файл и его распарсить.

Перебирать дерево элементов и наполнять модель вручную неудобно, так что нужна возможность
выбрать элементы из XML-файла автоматически и представить их в виде модели. 
Эти задачи и реализует XmlListModel.

XmlListModel – QML-компонент для определения модели данных.
Компонент позволяет создавать только Модель для чтений.
Запись в нее не будет поддерживаться.

Свойство source необходимо для указания пути к XML-файлу с данными.
Это может быть путь к локальному файлу или же путь к файлу на каком-нибудь веб-ресурсе.

Свойство query позволяет указать XPath запрос на получение элементов модели из XML дерева. 

Данные элементы имеют свойства/атрибуты (поля модели), для извлечения которых из XML
используется компонент XmlRole.
Объект XmlRole определяет поля Модели. 

Он имеет свойство name для определения имени атрибута, по этому имени мы сможем обращаться
к свойствам в делегате.

А также свойство query, в котором указывается запрос на извлечение значения данного
атрибута из XML.

## Пример модели xml

Пример xml-файла и кода, который считывает и обрабатывает данную модель.

В качестве примера создадим собственный XML файл со каталогом книг.

Наш XML будет иметь структуру, представленную на слайде.
Корневой элемент <catalog> и внутри него несколько элементов <book>.

У каждого элемента <book> есть свои дочерние элементы: <title>, <year> и <author>.

Итак мы имеем каталог книг, где у каждой книги определено название, год издания и автор.

Объект XmlListModel, созданный для парсинга данного файла, также представлен на слайде.

В качестве свойства source указывается имя файла при условии, что файл исходного кода,
где используется XmlListModel и XML-файл лежат в одной директории.

В качестве свойства query указывается XPath запрос к элементу <book>.
Таким образом модель получит доступ к любому объекту <book> внутри XML.

Далее необходимо получить доступ к элементам-атрибутам каждой книги.
Для этого используются объекты XmlRole.
Свойства name объектов XmlRole определяют имена свойств модели, по которым мы будем
к ним обращаться внутри представления.

А свойства query задают запрос к каждому атрибуту внутри элемента <book>.
Например, чтобы обратиться к элементу <title> внутри <book> необходимо описать запрос
“title/string()”, где string означает, что данное поле текстовое.
В случае с атрибутом year, после символа / указывается number(), что означает,
что данный атрибут числовой.

## Пример модели xml [2]

Продолжение примера. Отображение xml-модели на странице приложения.

Код на слайде демонстрирует простейший пример использования XmlListModel
на странице со списком записей. 
Здесь наглядно видно, что определенные нами, с помощью XmlRole, “имена” свойств модели
(title, year и author) используются в делегате компонента SilicaListView. 
Также стоит отметить, что XmlListModel и XmlRole вынесены в отдельный модуль
QtQuick.XmlListModel 2.0 и его нужно дополнительно импортировать.
