# WorkerScript

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Поток с WorkerScript

Тип WorkerScript позволяет JavaScript-коду запускаться параллельно с потоком графического
интерфейса.

Каждый экземпляр WorkerScript может подключаться к одному сценарию .js.
Когда вызывается WorkerScript.sendMessage(), скрипт запускается в отдельном потоке
(и в отдельном контексте QML).
Когда сценарий завершается, он может отправить ответ обратно в поток GUI, который вызовет
обработчик сигнала WorkerScript.onMessage().

Использование WorkerScript аналогично использованию рабочего объекта QObject, который был перемещен
в другой поток.
Данные передаются между потоками через сигналы.

Используйте WorkerScript для запуска операций в новом потоке.
Это полезно для выполнения операций в фоновом режиме, так что основной поток графического
интерфейса не блокируется.

## WorkerScript: пример QML

Сообщения могут передаваться между новым потоком и родительским потоком с помощью sendMessage()
и обработчиком onMessage().

WorkerScript указывает на файл JavaScript, «script.js», который обрабатывает операции, которые
должны выполняться в новом потоке.

Когда пользователь кликает в любом месте прямоугольника, вызывается sendMessage(), запуская
обработчик WorkerScript.onMessage() в script.js.

## WorkerScript: пример JS

Функция в файле, в свою очередь, отправляет ответное сообщение, которое затем получает обработчик
onMessage() у myWorker.

## WorkerScript: ограничения

Поскольку функция WorkerScript.onMessage() запускается в отдельном потоке, файл JavaScript
оценивается в контексте, отличном от основного движка QML.
Это означает, что в отличие от обычного файла JavaScript, который импортируется в QML, script.js
в приведенном выше примере не может обращаться к свойствам, методам или другим атрибутам элемента
QML и не может обращаться к любым свойствам контекста, установленным в объекте QML,
через QDeclarativeContext.

Кроме того, существуют ограничения на типы значений, которые могут быть переданы в и из WorkerScript.

sendMessage() отправляет данное сообщение обработчику WorkerScript в другом потоке.
Другой WorkerScript может получать это сообщение через обработчик onMessage().

Объект сообщения может содержать только значения следующих типов:

*	boolean, number, string;
*	объекты JavaScript и массивы;
*	объекты ListModel (любой другой тип QObject не разрешен).

Все объекты и массивы копируются в сообщение.
За исключением объектов ListModel, любые изменения другого потока для объекта, переданного
в сообщении, не будут отражаться в исходном объекте.
