# UI Kit и общие рекомендации

Copyright&nbsp;©&nbsp;2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## UI Kit

При разработке приложений с графическим интерфейсом пользователя следует использовать UI Kit.
Он доступен в Figma и на портале разработчика.

Данный UI Kit позволит легко начать проектирование интерфейсов под операционную систему Аврора.
В нём имеется компонентная база ОС и целый ряд полезных рекомендаций по созданию лучшего интерфейса для приложения.

## Обложки приложений

Обложка — это визуальное представление приложения, работающего в фоновом режиме на домашнем экране ОС Аврора.

Обложка каждого приложения на домашнем экране должна иметь уникальное оформление и, желательно, краткую информацию и/или элементы управления.

Обложки имеют прямоугольную форму.

Обложка любого приложения должна легко считываться среди прочих, присутствующих на экране, за счёт соответствующим ей иконки, цвету и содержимому.

## Иконки приложений

Экран приложений — один из основных элементов навигации по ОС Аврора.
Поэтому важно, чтобы иконки приложений легко считывались пользователем, но при этом оставались уникальными и запоминающимися.

Гармоничное сочетание цвета и формы, а также правильный подбор метафоры иконки помогут пользователю легко и быстро найти нужное приложение.

В качестве основной формы иконок приложений в ОС Аврора используется суперэллипс (сквиркл).
По умолчанию в систему загружаются иконки простой квадратной формы, без скруглений, далее, система сама обрезает иконку по маске суперэллипса.

В качестве фона рекомендуется использовать несложный радиальный градиент, состоящий из двух цветов одного тона схожих оттенков.

При создании градиента для сохранения визуальной согласованности всех иконок приложений стоит учитывать, что иконка должна быть «освещена» слева-сверху, то есть более светлый тон рекомендуется располагать в левом верхнем углу иконки.

Фоновый градиент обязательно должен быть достаточно контрастным, чтобы основная форма иконки легко на нём считывалась.

## Общие рекомендации

При разработке пользовательских интерфейсов следует придерживаться ряда рекомендаций
для создания удобочитаемых и функциональных приложений. 

Мы выделили некоторые из них: 

*	структура приложения должна быть простой для понимания и быстрой ориентации;
*	основная информация, которую важно указать, может выделяться позицией, цветом или размером;
*	интерфейс пользователя желательно должен быть отзывчивым и использовать сенсорные элемента
	для взаимодействия;
*	для различных экранов используются различные макеты страниц;
*	для компонентов ввода следует указывать подсказки и описание назначения элемента;
*	и для страниц с объемным содержимым всегда указывать индикатор прокрутки. 

## Рекомендации для Silica

Кроме общих рекомендаций, также стоит выделить несколько моментов при работе с библиотекой Silica.

Обложки рекомендуется делать информативными, но не перегруженными элементами или иконками действий.

Для указания значений размеров, цветов, отступов следует пользоваться свойствами компонента Theme,
на слайде указаны рекомендации для некоторых элементов. 

В вытягиваемых меню стоит указывать не более четырех опций для выбора, в противном случае такое
меню займет больше половины экрана. 

Если вытягиваемое меню не доступно, этого элемента не должно быть в коде.
Напомним, что индикатор присутствия меню - это подсвеченная полоса сверху или снизу. 

Диалоги не должны содержать дополнительных кнопок для подтверждения или отмены действия пользователя.

Поддержка навигации ввода осуществляется с помощью свойств placeholderText и label

Для работы с клавиатурой рекомендуется описать действия EnterKey.
