# Перевод на основе идентификаторов текста

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Перевод текста на основе идентификатора

Механизм перевода идентификатора текста - это система "промышленного уровня"
для интернационализации и локализации.
Каждому тексту в приложении присваивается уникальный идентификатор (текстовый идентификатор),
и эти идентификаторы используются непосредственно в исходном коде вместо простых текстов.
Это требует немного больше работы для разработчиков пользовательского интерфейса, но значительно
упрощает управление большим количеством переведенных текстов.
Примечание. В одном приложении вы должны использовать только функции на основе простого текста
или только на основе идентификатора текста.
Если вы смешаете их, вы получите неполный набор текстов для перевода.

## Интернационализация с идентификаторами

При использовании текстовых идентификаторов вместо простого текста общий метод интернационализации
приложения остается тем же, но детали немного отличаются:

1.	Функции и макросы для системы перевода на основе ID текста отличаются от системы обычного текста.
	Вы используете функцию qsTrId() вместо qsTr() и макрос QT_TRID_NOOP() вместо QT_TR_NOOP().
2.	Используйте текстовые идентификаторы в качестве строк пользовательского интерфейса, а не текстовые строки.
	Например, qsTrId("id-back-not-front")
3.	Нельзя указывать параметр контекста с текстовым идентификатором.
	Если есть одинаково написанные слова с разными значениями, им нужны отдельные идентификаторы текста.
4.	Текст «Инженерный английский», который вы видите в пользовательском интерфейсе для сборок
	для разработки, отмечен комментарием //%.
	Если вы не включите это, текстовый идентификатор будет показан в пользовательском интерфейсе.
	Это особенно важно, когда у вас есть тексты с параметрами.
	Комментарий //% должен включать индикаторы параметров в строку.
	Например, //% «Количество файлов:% 1»
5.	Комментарии //:, которые предоставляют дополнительную информацию переводчику, являются
	необязательными в системе простого текста.
	Однако в системе, основанной на текстовых идентификаторах, эта дополнительная информация
	становится необходимой, поскольку без нее у вас есть только текстовый идентификатор, и переводчик
	не сможет сделать разумный перевод из этого без дополнительного контекста.
	Вы можете использовать длинные текстовые идентификаторы с описанием и без комментариев,
	но комментарии часто легче понять.

## Пример перевода с идентификатором

Приведенные  фрагменты кода показывают сравнение переводов на основе текстового идентификатора и простого текста.

На слайде приведён пример на основе идентификаторов текста.

## Пример перевода на основе обычного текста

На слайде приведён пример на основе обычного текста.

## Переводы на основе идентификаторов

Локализация с помощью текстовых идентификаторов происходит практически так же, как и для простого текста.
Инструмент lupdate используется таким же образом, и переводы выполняются в файлы .ts.

Обратите внимание, что исходные значения в файлах перевода будут текстовыми идентификаторами,
а не простым текстом.
Это означает, что вам нужны очень описательные текстовые идентификаторы, или хорошие дополнительные
комментарии, или оба, чтобы гарантировать, что переводчик делает правильный перевод.

## Результат генерации

Пример текстового интерфейса пользователя на основе текстового идентификатора, приводит
к следующему содержимому в файле .ts.

## Запуск перевода

При использовании lrelease необходимо указать, что ключи для переведенных текстов основаны
на текстовых идентификаторах, а не на простых текстах.
Если строки в коде указаны с помощью qsTr(), атрибут «id» не устанавливается, поэтому lrelease игнорирует их.
Команда на слайде создает все скомпилированные файлы перевода .qm для вашего приложения.

Однако, если для данного текста нет перевода (что обычно имеет место до поздней стадии разработки),
текстовый идентификатор будет отображаться в пользовательском интерфейсе, а не в собственном тексте.
Чтобы сделать приложение более пригодным для тестирования, вы можете сделать так, чтобы lrelease
использовал исходный текст «Инженерный английский» (из комментариев //%) в качестве переведенного
текста и пометил его некоторым индикатором, чтобы вы могли видеть тексты, которые еще не были в переводе.
Например, вторая команда на слайде создает файлы .qm и ставит «!» перед непереведенными текстами.
