# Рекомендации по стилю переводов

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Правила переводов для русского языка

Первым шагом в локализации обычно является определение переводов для каждой видимой
пользователем строки в приложении или пользовательском интерфейсе.
Для основных компонентов и приложений ОС Аврора для определения строк перевода используется
инструмент перевода ОС Аврора.

Инструмент включает в себя идентификатор переведенной строки, описание контекста и инженерный текст
на английском языке для каждой видимой пользователем строки в операционной системе Аврора.
Затем переводчики могут внести новый перевод (или исправление в существующий перевод) для этой
строки для локализации, которую они хотят улучшить.
Строки перевода добавляются в специфичный для локали каталог, который затем индексируется
во время сборки, из которого приложения читают во время выполнения для отображения соответствующей
переведенной строки в пользовательском интерфейсе.
Файл перевода также определяет направление компоновки (например, слева направо и сверху вниз,
справа налево и сверху вниз и т. д.), требуемое для этой локали.

## Руководства и принципы стиля переводов

Эта часть содержит общие рекомендации по стилю для ОС Аврора. 

Основы хорошего стиля письма

*	Пишите в безличном стиле, не затрагивая пользователей.
	Используйте стандартные формы для поддержания высокого качества:
	*	Правильно: Выбор из музыкальных файлов.
	*	Неверно: Выбери из музыкальных файлов.
*	Удостоверьтесь, что текст последовательный, четкий и правильный в грамматике и правописании.
*	Пишите короткими предложениями.
*	Используйте позитивный тон, избегайте негативных выражений.
*	Избегайте двусмысленности.
	Убедитесь, что местоимения четко указывают на соответствующие существительные,
	и избегайте длинных цепочек модификаторов или существительных.
*	Помните, что наиболее важной частью является предоставление четкого сообщения.
*	Обратите внимание, что в технических текстах описания и инструкции не должны включать текст,
	написанный с маркетинговой точки зрения.

## Язык и культура

Поскольку наше общение предназначено для международного использования и его часть будет
переведена, постарайтесь сохранить языковой язык в культурном отношении, будьте осторожны
с религиозными ссылками и избегайте использования идиоматических выражений или сленга.
Ключевыми аспектами являются ясность и простота.
Учитывайте эти цели при адаптации веселого тона в текстах.

В переводах пользовательского интерфейса программного обеспечения: уважайте исходный текст,
но не создавайте слово для перевода слов.
Учитывайте контекст при переводе.

## Руководства и принципы стиля

Будьте формальными во всех случаях.
Избегайте использование специфического для пола языка, а также местоимений.
И все же, если иначе невозможно, используйте второе лицо и множественное число формального
местоимения «вы».
Продолжайте обращаться последовательно: например, если абзац был начат с использованием второго
лица, сохраните его во всех его предложениях (не переходите к третьему лицу
или нейтральному настроению).

Используйте нейтральные с гендерной точки зрения или всеобъемлющие термины для обозначения
людей, а не термины, которые включают в себя термин «мужчина», «женщина» и аналогичные термины
«мужской» и «женский».

## Глаголы

Используйте настоящее время.
Например:

*	Правильно: Потребуется перезапуск.
*	Неправильно: Твой телефон перезапустится.

По возможности используйте активную форму глаголов.

Сохраняйте ясность сообщения и короткие предложения.
Например:

*	Правильно: Выберите Удалить все, чтобы удалить сохраненные сообщения.
*	Неправильно: Сохраненные сообщения удаляются с помощью опции Удалить все.

Используйте императивную форму:

*	Правильно: Переход к настройкам.
*	Неправильно: Перейди к настройкам.

## Общие принципы стиля

Используйте названия приложений и названия компаний с большой буквы.
В пользовательском интерфейсе начните первое слово с заглавной буквы.
Соблюдайте правила использования заглавных букв в языке.

Элементы меню пользовательского интерфейса называйте с использованием глаголов.

Пустые состояния пользовательского интерфейса обычно записываются в форме из двух предложений,
с использованием глаголов и активного тона и, где это возможно, направляют пользователя
к следующим возможным шагам.
Делайте предложения короткими, а содержание информативным.
По возможности, направляйте пользователя на то, чтобы отразить хорошие стороны приложения
или сервиса (например, обращение к друзьям вместо контактов в приложении «Люди»).
Например: <Сообщите, какие элементы отсутствуют> <укажите пользователю на следующие
действия> → <Нет контактов.> <Потяните вниз, чтобы добавить своих друзей.>

Обложки приложений (которые отображаются на главной странице) для пустых состояний должны быть
короткими информативными сообщениями.
Длина обычно составляет два слова.

## Пунктуация

В строках пользовательского интерфейса не используйте точку в конце предложения, если есть
только одно предложение.
Если есть два или более предложений, используйте обычные точки.
Если сегмент заканчивается двоеточием или многоточием, перевод должен следовать за источником.

## Сокращения

*	В техническом письме используйте общие сокращения.
	*	Не используйте латинские сокращения.
*	В пользовательском интерфейсе используйте общие сокращения, в том числе латинские сокращения.
	*	Убедитесь, что четкость текста не пострадает. В случае сомнений не используйте аббревиатуру.
*	Не используйте точки в или после аббревиатур, например:
	*	Правильно: WLAN.
	*	Неправильно: W.L.A.N.
*	Не используйте точки с символами единиц (измерений), например:
	*	Правильно: кг
	*	Неправильно: кг.
*	Используйте точки с латинскими сокращениями, например:
	*	Правильно: т.е., т.д.
	*	Неправильно: те, тд.

В случае русского языка, где это возможно, избегайте использования сокращенных форм,
если они не получили широкого признания.

Если вам необходимо объяснить аббревиатуру или аббревиатуру на английском языке, которая
не имеет эквивалента на русском языке, укажите свое объяснение в скобках, когда впервые вводите
аббревиатуру или акроним.

## Тире и дефис

*	Если есть необходимость в тире, обязательно используйте длинное тире (Alt + 0151).
	Не путайте его с дефисом (-).
*	Тире длиннее и имеет пробел до и после нее.
	Использование тире вместо дефиса и наоборот - ошибка.
*	Короткое тире редко используется на русском языке.
	Используйте его в следующих ситуациях:
	*	1917-2013;
	*	100-150.
*	Дефис используется в телефонах: тел. 5-13-43.
*	Дефис также используется в слоговых переносах русских слов.

## Запятые

Используйте запятую между независимыми предложениями, к которым присоединяются,
и если вы логически можете заменить «и» на «а».

Используйте запятую для разделения элементов в перечислении, за исключением двух последних
элементов: Создать, изменить и удалить.

Используйте точку с запятой для разделения элементов в серии, когда один или несколько
элементов имеют внутреннюю пунктуацию.

## Цитирование, списки и заголовки

Соблюдайте правила цитирования языка.

Для технического написания на русском языке: используйте «» кавычки вместо ‘’ или “”.
При необходимости используйте фигурные кавычки в качестве внутренних кавычек.
Пожалуйста, соблюдайте последовательность в этом конкретном стиле по всему тексту.

В техническом письме пишите списки с точками.
В пользовательском интерфейсе пишите списки без точек или двоеточий.

В техническом письме создавайте структурированные, последовательные и точные заголовки.

## Модули и процедуры

При написании технических документов убедитесь, что каждый модуль может быть прочитан независимо
и содержит всю необходимую информацию, чтобы модули не читались в определенном порядке.

В техническом письме, при описании процедур, убедитесь, что четко описали шаги только с одной
задачей на шаг.
Опишите ожидаемые результаты этих шагов.

## Числа

*	Напишите числа в виде цифр, в том числе цифры ниже 10.
	*	Правильно: Получено 1 новое сообщение.
	*	Неправильно: Получено одно новое сообщение.
*	Используйте цифры для измерений.
*	Используйте пробел между цифрой и единицей, кроме знака степени и процента:
	*	Правильно: 5 см, 20°, 20 °C.
	*	Неправильно: 5см, 20 °, 20°C.

Пожалуйста, проконсультируйтесь с Государственной системой по обеспечению единства измерений
(редакция ГОСТ 8.417-2002), чтобы использовать правильный интервал с единицами измерения.

## Юридические детали

ОС Аврора имеет отдельный проект терминологии для обеспечения согласованности.
Используйте эту утвержденную терминологию, когда она доступна.

Не переводите названия компаний, если нет официального переведенного названия.

Не переводите названия продуктов или товарные знаки.

Предупреждения, предостережения и примечания являются юридическими текстами, которые должны
быть подтверждены юридическим отделом.
В случае юридических текстов, внимательно следуйте инструкциям и попросите дополнительную
информацию, если это необходимо.

## Контрольный список для проверки

При завершении переводов для пользовательского интерфейса проверьте следующее:

*	Все было переведено.
*	Проверка орфографии завершена.
*	Проверьте соответствие с другими переводами, сделанными для языка.
*	Убедитесь, что используется правильная терминология ОС Аврора. Если необходимо, предложите новые термины.
*	Проверьте юридические тексты на соответствие источнику.
*	Названия компаний и продуктов, товарные знаки, символы и размеры не пишутся через дефис.
*	Убедитесь, что сохранены региональные форматы, такие как дата, время, числовые и литеральные кавычки.

При окончательной доработке текстов для технического письма также проверьте следующие моменты:

*	Заголовки и заголовки структурированы и точны.
*	Язык понятен и последователен.
*	Предложения различаются по длине и имеют четкую форму.
