# Состояния и переходы

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Состояния и управление свойствами

Одна из распространенных конструкций пользовательского интерфейса — интерфейс, управляемый состояниями.
Суть данного принципа в том, что интерфейсы имеют различную конфигурацию в зависимости от текущего состояния.
QML имеет встроенные инструменты, позволяющие реализовать состояния для различных объектов языка.

Механизм работы с состояниями в QML представляет из себя некое подобие графа, где в качестве вершин
выступают конкретные состояния, а ребра — это условия перехода между ними.
У всех объектов, основанных на Item, есть свойства states и state.
В свойстве states хранится список всех состояний, определенных для объекта.
Даже если не задавать ни одного состояния, в переменной states будет всегда содержаться одно начальное состояние,
которое содержит изначальный свойства объекта и имеет пустую строку в качестве названия.
Новые состояния могут быть определены добавлением объектов State в свойство states, что позволяет объекту
переключаться между различным наборами конфигураций.
Название текущего состояния объекта находится в свойстве state, а изменение текущего состояния может
производится присваиванием свойству state название другого состояние.

State — QML-компонент, назначение которого — описание состояний объекта и условий перехода между ними.
Он представляет собой набор изменений значений свойств относительно начальной конфигурации объекта.
У каждого объекта происходящего от Item имеется как минимум одно состояние — состояние по-умолчанию.
Каждое состояние внутри одного объекта имеет свое уникальное название, в случае начального состояния
в качестве название выступает пустая строка.
Обращение к объектам из State идет по их id.

State — конфигурации объектов и свойств:

*	name : string — название состояния;
*	extend : string — расширяемое состояние;
*	when : bool — когда состояние наступает;
*	changes : list<Change> — изменения для прихода в состояние.

Элемент PropertyChanges используется, чтобы задать новые значение свойств при изменении состояния.
Переходя в новое состояние, значения в соответствующем PropertyChanges будут применяться к объекту.
Таким образом, можно задать новое значение свойства или осуществить привязку к другому параметру.
Кроме того, это позволяет переопределить обработчики событий объекта.

PropertyChanges обладает некоторыми свойствами, определяющими, как будет происходить изменение
состояния в той или иной ситуации.
PropertyChanges не позволяет изменить какие-либо значение anchors, кроме margins,
так как за это отвечает другой элемент.

*	target : Object — объект для изменения свойств;
*	explicit : bool — задать свойства один раз вместо привязок;
*	restoreEntryValues : bool — восстановить предыдущие значения при выходе из состояния.

## Пример PropertyChanges

Пример показывает, как изменение состояния привязывается к нажатию на область.

Изменение конкретных свойств определяется при помощи PropertyChanges.

## Transition — анимации при смене состояний

Переход определяет анимацию, которая будет применяться при изменении состояния.

У каждого наследника Item имеется свойство transitions — список переходов между состояниями.

Свойства компонента Transition:

*	animations : list<Animation> —  выполняемые анимации;
*	from, to : string — изменения состояний, которые вызывают переход;
*	reversible : bool — обратный переход;
*	enabled : bool — выполнять ли переход.

## Пример Transitions

Пример задания анимации для переходов между состояниями.

У прямоугольника есть два состояния, только одно из них имеет явно заданное имя blue.

При описании переходов медлу состояниями достаточно указать одно состояние, исходное или целевое.
