# Меню

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## AppBar — контейнер для навигации

AppBar — это стилизованный контейнер для организации навигации в приложениях.
AppBar состоит из блока заголовка, блока компонентов и контекстной подсказки.
Блок заголовка не является обязательным.
Блок заголовка состоит из iconContainer, заголовка (headerText) и подзаголовка (subHeaderText).

Блок компонентов используется для размещения элементов AppBar.
Контекстная подсказка используется, когда соответствующие компоненты сфокусированы жестом вытягивания.

## Элементы AppBar

Компоненты управления, которые можно использовать внутри компонента AppBar.

*	AppBarButton — Компонент кнопки для использования в AppBar.
	*	text — Текст метки, отображаемой на кнопке.
	*	icon — Значок, показанный внутри кнопки.
	*	context — текст, который будет отображаться в блоке контекстной подсказки AppBar, когда компонент находится в фокусе.
*	AppBarSearchField — Текстовое поле для ввода поискового запроса.
	*	context — текст, который будет отображаться в блоке контекстной подсказки AppBar, когда компонент находится в фокусе.
	*	placeholderText — текст, который будет отображаться, когда text пуст.
	*	text — отображаемый текст.
*	AppBarSpacer — Заполняет пространство.

## Пример AppBar

На слайде представлен пример панели AppBar.

## PopupMenu — всплывающее меню

PopupMenu служит для создания всплывающего меню.
PopupMenu имеет постраничную вёрстку, каждая страница может содержать список PopupMenuItem
и производных от PopupMenuItem компонентов.

Позиционирование PopupMenu полностью автоматизировано.
Для показа PopupMenu необходимо передать в метод open(baseItem) базовый элемент baseItem,
от которого будет рассчитываться позиционирование PopupMenu на экране.
Если метод open(baseItem) вызвать без аргументов, то расчёт позиции будет происходить от родительского элемента.

## Элементы PopupMenu

Компоненты управления, которые можно использовать внутри компонента PopupMenu.

*	PopupMenuItem — Стандартный элемент для PopupMenu.
	*	text — основной текст.
	*	hint — дополнительный текст. Отображается под основным текстом.
	*	icon — иконка слева от текста. Иконка должна быть размером Theme.iconSizeSmallPlus.
	*	clicked() испускается при выборе пункта меню пользователем.
*	PopupMenuCheckableItem — Элемент меню с переключателем.
	*	checked  — состояние переключателя.
		При нажатии на элемент сначала испускается сигнал clicked(), а затем меняется состояние checked.
*	PopupMenuDividerItem — Элемент-разделитель для PopupMenu.
*	PopupSubMenuItem — Вложенное меню для PopupMenu.
*	PopupToolMenuButton — Кнопка для панели инструментов PopupToolMenu.

## Пример PopupMenu

На слайде представлен пример меню PopupMenu.

## MenuItem и MenuLabel — элементы меню

Меню позволяют выбирать и запускать действие из списка параметров. 

В Silica есть три типа меню - вытягиваемые сверху и снизу страницы и контекстное меню,
применительно к списку элементов.

Для начала познакомимся с содержимым меню.
Пункты меню описываются с помощью типа MenuItem и обладают свойствами, позволяющими задать
текст и шрифт пункта меню, его цвет, а также горизонтальное выравнивание текста.
MenuItem также обладает сигналом onClicked, необходимым для обработки нажатия на пункт меню.

MenuLabel представляет собой статичный пункт меню, который просто отображает некоторый текст.
Такие пункты используются, например, в качестве заголовка или разделителя между интерактивными
пунктами меню.
Свойствами этого типа можно задать текст метки для описания назначения данного элемента,
цвет меню и вертикальный отступ от границ экрана. 

## PullDownMenu — верхнее меню

Вытягиваемые меню вызываются с помощью свайп жеста, поэтому их можно использовать только
внутри контейнеров, которые данный жест позволяют, а именно SilicaFlickable, SilicaListView,
SilicaGridView и SilicaWebView.

Меню же, в свою очередь, являются контейнерами для типов MenuItem и MenuLabel. 

Настроить данные меню можно с помощью свойств, задающих отступы, а также цвет их фона и подсветки.
Обратите внимание, что индикаторы вытягиваемых меню отображаются с помощью подсвеченных полос
сверху или снизу.
Цвет полос зависит от подсветки меню.

Флаг quickSelect позволяет включить функцию быстрого выбора, работает в случае меню с одним пунктом.
При значении true, при любой прокрутке меню будет выбран его единственный пункт автоматически. 

Метод close() закрывает меню вручную. 

Пункты меню определяются не в порядке их появления на экране при свайп жесте, а в порядке их
присутствия в самом меню, сверху вниз.
То есть и в вытягиваемом меню и сверху и снизу, первый пункт будет выше остальных, как указано
в примере.
В реальных приложениях не стоит использовать слишком много пунктов меню и тем более MenuLabel
компонентов.

## ListItem — элемент списка с меню

Тип ListItem позволяет управлять размерами делегата, задавая нормальную высоту.
Высота элемента будет увеличиваться при открытии контекстного меню, но высота содержимого
не изменится.

Флаг highlighted подсвечивает содержимое, когда контекстное меню открыто.
Также можно установить вызов меню с помощью нажатия и удержания элемента списка.

remorseAction() создаёт элемент, который позволяет отменить разрушающее действие, например,
удаление.

ContextMenu – тип, предоставляющий всплывающее контекстное меню.

Содержимое этого меню описывается так же, как и для вытягиваемых, с помощью компонентов
MenuItem и MenuLabel.
Чаще всего данный тип используется для реализации контекстного меню элементов списка.

Для этого у компонента ListItem, который используется для описания делегатов списка,
есть специальное свойство menu.

## ContextMenu — контекстное меню

Давайте посмотрим простейший пример по добавлению контекстного меню к элементам списка.
В свойстве menu мы описали контекстное меню и создали интерактивный пункт меню, который меняет
стиль шрифта метки на жирный. 

После того, как пункт меню будет выбран, контекстное меню будет закрыто автоматически.
