# Поля ввода

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## TextField — ввод однострочного текста

Для ввода текста в ОС Аврора используются типы TextField и TextArea.

TextField — QML-тип для ввода и редактирования однострочного текста.
Помимо вводимого текста и стандартных методов работы с ним, TextField обладает свойством
placeholderText, отображаемый в поле до ввода пользователем.
В этом свойстве можно задать подсказку для пользователя, с началом ввода текст исчезнет.

Свойство label задает текст, который отображается под полем сразу после начала ввода пользователем.
Запрет ввода текста устанавливается флагом readOnly, а кроме непосредственно ввода текста в данном
компоненте мы можем задать специальную клавиатуру, служащую подсказкой для ввода, формат кнопки
Enter и осуществить проверку ввода с помощью валидаторов. 

## TextField — однострочный ввод

В данном примере мы задале поле для ввода числа от -10 до 10, эту подсказку мы описали
в свойстве placeholderText, а в свойстве label указали назначения поля.
Для ввода чисел мы задали специальную клавиатуру, а валидатор ограничил нас в допустимом диапазоне.
Также мы поработали над кнопкой ввода - запретили ее подсветку, назначили ей определенную иконку,
а при клике на ней, выводим текст пользователя в консоль. 

## InputMethodHint — управление вводом

Давайте подробнее рассмотрим перечень доступных клавиатур для ввода. 

*	Qt.ImhDialableCharactersOnly –  предназначенна для ввода телефонного номера. 
*	Qt.ImhDigitsOnly – позволяет вводить только целые числа.
*	Qt.ImhEmailCharactersOnly – позволяет вводить только символы, допустимые в адресах электронной почты.
*	Qt.ImhFormattedNumbersOnly – позволяет вводить только десятичные числа.
*	Qt.ImhNoPredictiveText – отключает возможность предиктивного(интеллектуального) ввода.
*	Qt.ImhUrlCharactersOnly – позволяет вводить только символы, допустимые в веб-адресах.
*	Qt.ImhNoAutoUppercase – отключает автоматическое переключение в верхний регистр в начале предложения.

Допустимо и использование сразу нескольких установок свойства одновременно с помощью символа “|”.

## Validator — проверка ввода [1]

Валидатор используется для фильтрации введенного текста и предотвращения ввода недопустимого текста.
Этот элемент проверяет, вводится ли пользователем в поле тот тип данных, который задан при создании
этого поля.

Три типа валидаторов позволяют задать ввод целых или вещественных чисел и ввод согласно заданному
регулярном выражению. 

## Validator — проверка ввода [2]

Числовые валидаторы задают границы доступимого диапазона, для вещественных чисел также задается
количество цифр после запятой.
Кроме этого задается локаль для отображения числа в нужном формате и необходимая нотация,
по умолчанию используется экспоненциальная нотация. 

## TextArea — многострочный ввод [1]

TextArea — QML-тип для ввода и редактирования многострочного текста.
Компонент обладает практически теми же свойствами, что и TextField, однако имеет несколько важных
отличий. 

Во-первых, для TextArea невозможно использования валидаторов и заданных виртуальных клавиатур.
Во-вторых, в отличие от TextFiled здесь присутствуют свойства для горизонтального и вертикального
выравнивания, а также для установки режима переноса текста на следующую строку.
По умолчанию свойсто WrapMode принимает значение NoWrap.

Если у TextArea не заданы ширина и высота, то площадь будет изменяться в соответствии с введенным
текстом, то есть, он будет выходить за пределы экрана или увеличиваться вниз.
Поэтому рекомендуется установить значения для размера. 

## TextArea — многострочный ввод [2]

В примере мы описали два объекта textArea, в первом случае мы указали режим переноса по словам,
во втором случае в свойстве текст мы заранее ввели то, что хотим увидеть на экране.
Здесь мы не задавали режим переноса, однако в значении свойства мы добавили символы переноса
каретки, которые были распознаны.

## PasswordField — ввод пароля

PasswordField реализует текстовое поле для ввода пароля.
Оно включает в себя кнопку, которая переключает режим отображения вводимого текста echoMode
с TextInput.Normal на значение свойства passwordEchoMode.
Значение по умолчанию: TextInput.Password.

PasswordField наследуется от TextField.

showEchoModeToggle определяет, будет ли отображаться кнопка, которая переключает режим отображения
вводимого текста echoMode.

## SearchField — строка поиска

SearchField отображает поле поиска — одну строку редактируемого текста вместе со значком поиска
и кнопкой, которая очищает введённый текст.
SearchField наследуется от TextField, поэтому свойство text можно использовать для доступа к введённому тексту.

Свойство textLeftMargin относится к положению текста внутри поля поиска.
Поэтому вводимый в поле поиска текст можно использовать в качестве ориентира для выравнивания
относительно него других элементов, например, элементов списка при фильтрации.
