# Контейнеры

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Контейнеры

Организацию содержимого страницы обеспечивают контейнеры. 

Большинство этих контейнеров унаследовано от компонентов QtQuick и обладают всеми свойствами
родителей, однако есть и собственные, например SlideShowView, DockedPanel и Drawer. 

## SilicaFlickable — общий контейнер [1]

Контейнер SilicaFlickable добавляет возможность прокрутки страницы, если ее содержимое превышает
размеры экрана.
Также этот контейнер позволяет добавлять на страницу элементы вытягиваемых меню.
Методы ScrollToBottom и ScrollToTop позволяют быстро прокрутить содержимое к концу или началу страницы.
С помощью quickScroll можно включить или отключить вертикальную область быстрой прокрутки.

Хорошим тоном считается использование декораторов прокрутки при использовании типов, которые
поддерживают возможность прокручивания.
Декораторы прокрутки представлены типами ScrollDecorator, VerticalScrollDecorator и HorizontalScrollDecorator.
ScrollDecorator позволяет отображать и вертикальный и горизонтальный декораторы одновременно. 

## SilicaFlickable — общий контейнер [2]

В примере мы описали объект типа SilicaFlickable и внутрь него поместили контейнер Column и создали
возможность прокрутки изображений.
В этом случае добавляем вертикальный индикатор прокрутки. 

## SilicaListView — список элементов [1]

Организовать контент в виде списка возможно с помощью SilicaListView.
Данный контейнер обладает свойстивом model, определяющим данные, которые будет отображать список,
а также свойством delegate, определяющим внешний вид элементов списка.

## SilicaListView — список элементов [2]

Простейшим примером модели может быть компонент ListModel, являющийся контейнером
для объектов типа ListElement. 

Для визуализации ползунка прокрутки также нужно использовать VerticalScrollDecorator

В примере мы описали модель списка из 100 элементов, каждый из которых состоит из текста Item
и индекса элемента, начинающегося с единицы.
Подробнее на моделях и делегатах мы остновимся в следующем модуле. 

## SilicaGridview — таблица [1]

SilicaGridView, как и  его родитель, позволяет отображать набор элементов в виде таблицы.
Этот тип обладает свойствами модель и делегат, а также свойствами, позволящими настраивать размер ячеек.
К таблице можно применять как вертикальный, так и горизонтальный индикатор прокрутки. 

## SilicaGridview — таблица [2]

Пример также содержит в себе набор из 100 элементов, в виде их индекса.
Эти элементы организованы в таблицу из 4 столбцов, и, соответственно 25 колонок. 

## SlideshowView — слайды по циклу [1]

SlideshowView – QML-компонент для отображения данных в виде слайдшоу. 

Перелистыванием элементов в слайдшоу управляет пользователь. 
Навигация по SlideshowView циклическая. После последнего элемента будет отображен первый.

SlideshowView так же как SilicaListView и SilicaGridView обладает свойствами model и delegate.

Свойства itemHeight и itemWidth определяют высоту и ширину элемента в слайдшоу. 

Кроме того, можно задать ориентацию переключения слайдов - вертикально или горизонтально. 

## SlideshowView — слайды по циклу [2]

Пример содержит в себе модель из 5 элементов. По умолчанию, переключение слайдов происходит горизонтально. 

## SilicaWebView — веб-страница [1]

Для отображения веб-страниц используется контейнер SilicaWebView.

SilicaWebView обладает свойством url, где указывается адрес веб страницы, которая может быть
загружена, или которая загружена при клике внутри страницы.
Данное свойство может быть пустым, если страница загружается из HTML-кода, а не по адресу.

Свойства title, loading и loadProgress — только для чтения.
Они позволяют узнать информацию о загружаемой странице (ее заголовок) и о процессе загрузки
(загружается ли она и каков прогресс загрузки).

## SilicaWebView — веб-страница [2]

Код на слайде показывает простейший пример создания веб браузера.

На странице описан контейнер SilicaWebView, а внизу страницы расположен объект типа TextField
для ввода веб-адреса.

По нажатию на клавишу “Enter” на виртуальной клавиатуре произойдет изменение свойства url
у SilicaWebView и будет загружена новая страница.

## Панель DockedPanel

DockedPanel — это контейнер, который пристыкован к краю компонента типа ApplicationWindow
или Page и расширяется от этого края, чтобы отображать содержимое по требованию.
Сдвиг DockedPanel (отображается поверх родительского элемента) в направлении к краю приведёт к его закрытию.

dock : enumeration — к какому краю родительского элемента пристыкован DockedPanel.
Значение по умолчанию: Dock.Bottom.

[read-only] visibleSize : real содержит ширину или высоту видимой части DockedPanel.

open : bool — открыт ли DockedPanel.
Изменение значения свойства open приведёт к тому, что панель будет открыта или закрыта.

## Пример DockedPanel

Код на слайде показывает, что может содержать пристыкованная панель.

## Панель Drawer

Drawer — это контейнер, состоящий из двух панелей, одна из которых может быть сдвинута, чтобы
отобразить содержимое второй панели.

background : list содержит дочерние элементы backgroundItem.
Эти элементы показываются при открытии выдвигающейся панели.

backgroundItem : Item содержит родительский элемент для элементов, заданных в свойстве background.

dock : enumeration — от какого края будет открыта панель Drawer.
Значение по умолчанию: Dock.Top.

open : bool — открыт ли Drawer.
Изменение значения свойства open приведёт к тому, что панель будет открыта или закрыта.

## Пример Drawer

Код на слайде показывает, что может содержать выезжающая панель.
