# Базовые компоненты: метки и кнопки

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Qt Quick — технология быстрой разработки

Как мы уже обсуждали ранее, основные типы для создания пользовательских интерфейсов на основе QML
содержаться в модуле Qt Quick.
Для работы с сенсорными компонентами фреймворк Qt использует модуль Qt Quick Controls.
Однако для разработки интерфейсов в ОС Аврора есть библиотека собственных компонентов Silica,
учитывающая особенности этой операционной системы.

Silica позволяет создавать пользовательские интерфейсы приложений, которые соответсвуют визуальному
стилю ОС Аврора и изменяют его в зависимости от атмосферы, ведут себя в соответствии
со стандартными приложениями и используют уникальные для ОС Аврора элементы, например,
вытягиваемые меню и обложки приложений.

Для разработки приложений ОС Аврора в qml документе необходимо импортировать модуль Qt Quick
(версия от 2.0 до 2.6) и модуль Sailfish.Silica 1.0.

## Визуальные элементы Silica

Библиотека содержит как визуальные, так и невизуальные элементы, все доступные на данный момент
компоненты можно посмотреть на слайде. 

## Невизуальные элементы Silica

Зеленым цветом отмечены элементы модуля Qt Quick, желтым - библиотеки Silica.

## Label — вывод текста [1]

Label – QML-компонент для отображения стилизованного текста в ОС Аврора.
По умолчанию цвет текста и шрифт устанавливаются в соответствии с текущей атмосферой. 

Label унаследован от компонента Text, поэтому все его свойства, методы и сигналы так же доступны
и для объектов этого типа.

Однако у Label есть и свое собственные свойства, с помощью которых можно подсветить текст, выделив
его на странице, задать собственную цветовую палитру с помощью свойства palette. 

## Label — вывод текста [2]

Свойство truncationMode определяет какой эффект будет применен к тексту, если строка не помещается
в элемент Label полностью.

*	Значение None используется по умолчанию и в этом случае текст будет просто обрезан в конце элемента Label.
*	Значение Elide преобразует не умещающийся текст в троеточие в конце строки.
*	Значение Fade делает конец строки затухающим как показано на слайде. 

При разработке под ОС Аврора принято использовать значение Fade для однострочного текста
и Elide для многострочного.

## LinkedLabel — форматируемый текст [1]

Тип LinkedLabel предоставляет текстовый абзац в стиле ОС Аврора со встроенным синтаксическим
анализатором, который обнаруживает URL-адреса, номера телефонов и адреса электронной почты
и выделяет их в качестве вставляемых ссылок.
При нажатии на ссылку открывается приложение, установленное в качестве обработчика по умолчанию
для типа ссылки, например, браузер, телефонная книга и другие.

Действия ссылок можно отключить, установив флаг defaultLinkActions в значение false, а добавить
собственную обработку ссылок можно, реализовав обработчик сигнала onLinkActivated.

Текст, заданный в свойстве plainText, будет обработан анализатором ссылок, а флаг shortenUrl
помогает сократить url адрес в тексте, в частности, убрать название протокола.

## Пример LinkedLabel

Свойство linkColor устанавливает цвет для ссылки, по умолчанию используется цвет атмосферы,
предназначенный для подсвеченных элементов.
Подробнее о работе с цветами будем говорить в уроке, посвященному стилизации интерфейса приложений.

## Button — кнопка

Перейдем теперь к элементам управления.
Наиболее используемый элемент - это кнопка.
Тип Button задает стилизованную кнопку с текстовой меткой.

Компонент Button наследует QML тип MouseArea поэтому любые свойства, методы и обработчики сигналов
будут унаследованы. 

Размеры кнопки можно установить в свойстве preferredWidth.
Не рекомендуется устанавливать ширину кнопки явно.
Правильный подход в этом случае - воспользоваться размерами компонента Theme.
О нем мы поговорим подробнее в уроке о стилизации. 

В примере мы описали простую кнопку среднего размера, выровненную посередине страницы.
В свойстве текст можно задать нужную команду.
Обработчик сигнала onClicked выводит в консоль уведомление о нажатии кнопки. 

## Кнопка в виде иконки

Эта кнопка позволяет задать иконку вместо текста.
Отображается такая кнопка в виде круга.
Свойство highlighted отражает подсвечена ли кнопка или нет.
Свойство icon позволяет задать изображение для кнопки.
Поскольку иконка представлена типом Image, мы можем работать со свойствами этого компонента.

В данном примере используется одна из встроенных иконок из Silica, здесь мы увеличили ее размер
в два раза, однако лучше использовать для этого свойства типа Theme, чтобы получить возможность
подстраивать размеры кнопки под различные размеры экрана.

## Кнопка со значением

Тип ValueButton предоставляет интерактивный элемент управления со стилизованной меткой и значением.
Данная кнопка позволяет отображать дополнительную информацию в своём теле.
Вместо text  здесь представлены 3 свойства: label, value и description.
Свойства label и value содержат текст кнопки и выбранное значение соответственно.
Свойство description содержит описание кнопки. 

Обычно такая кнопка используется для отображения результата действия пользователя.
Например, приведенный ниже код представляет собой счетчик нажатий, инкриминируя значение свойства value. 

## Группа кнопок

Тип ButtonLayout — контейнер, управляющий расположением элементов типа Button
согласно правилам стилизации ОС Аврора.

Обычно он используется для группировки кнопок, управления их размерами и положением на экране.
Это позволяет достичь приятного вида на различных типах устройств.

ButtonLayout позволяет убедиться, что все элементы Button выстроены в ряд и имеют одинаковый размер.
Для кнопок в контейнере ButtonLayout будут всегда выбираться стандартные размеры
(Button::preferredWidth) до тех пор, пока текст не перестанет умещаться в кнопку
с размером Theme.buttonSizeLarge.
