# Share API

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QML-модуль Share

QML-модуль Share позволяет загружать пользовательский интерфейс для обмена данными и отображать
список средств отправки.
С помощью этого модуля пользователь имеет возможность делиться файлами и прочим контентом,
отправляя данные любым доступным способом, например, по Bluetooth, SMS, электронной почте и т. д.

Пересылаемые файлы могут иметь любой MIME-тип, который определяет список возможных средств
для обмена данными.

## ShareResource — тип для ресурсов

ShareResource — это тип для ресурсов.
Данный тип нельзя создать напрямую из QML.

Свойства:

*	type : int
	Ресурсы могут иметь два разных типа: ShareResource.StringDataType и ShareResource.FilePathType.
	Доступ к различным свойствам зависит от типа ресурса, при этом доступ к ShareResource::type
	предоставляется в обоих случаях.
*	data : string
	Содержимое ресурса для отправки, если тип ресурса — ShareResource.StringDataType.
*	name : string
	Имя ресурса для отправки, если тип ресурса — ShareResource.StringDataType.
*	filePath : string
	Путь к файлу для отправки, если тип ресурса — ShareResource.FilePathType.

## ShareAction — отправка данных

QML-тип ShareAction запускает пользовательский интерфейс для отправки данных
из предопределённой конфигурации.

mimeType - MIME-тип ресурсов для отправки.
Доступные средства отправки при работе с указанными ресурсами зависят от выбранного MIME-типа.
Если свойство не установлено, оно автоматически генерируется на основе значения resources.

resources — список ресурсов для отправки.
Допускаются следующие типы ресурсов:

*	url или string: путь к файлу в локальной файловой системе.
	URL-адреса преобразуются в строковый формат.
	В случае, если путь начинается с file:///, то такая схема будет удалена;
*	map: содержит необработанные данные контента и связанные с ними метаданные.

title - текст заголовка для отображения в пользовательском интерфейсе отправки.

trigger() - запускает интерфейс для отправки.

## ShareProvider — получение данных

QML-тип ShareProvider принимает отправленные файлы и оповещает о передаче данных другим приложением.

capabilities - список MIME-типов, которые принимает метод отправки.
Если требуется принудительно проверять получаемые MIME-типы при отправке, следует установить
для этого параметра то же значение, что и для X-Share Method <method>/Capabilities.
Не следует доверять тому, что содержимое ресурса соответствует заявленному MIME-типу.
Компонент только проверяет, соответствует ли получаемый MIME-тип установленному здесь
значению capabilities.

method - имя метода отправки, определённое в desktop-файле.
Необходимо установить методу то значение, которое указано в списке X-Share-Methods и в имени
раздела X-Share Method в desktop-файле приложения.

registerName - для автоматической регистрации имени на сессионной шине D-Bus, необходимо
установить свойству значение true.

triggered(list resources) испускается при использовании метода отправки.
Аргумент представляет собой список ресурсов, которые были предоставлены приложению.

## Пример Share: desktop-файл

Пример использования QML-модуля Share.

Для того, чтобы приложение могло быть отображено в диалоге «Поделиться», необходимо в desktop-файл
добавить описания методов обмена данными.
Каждый метод должен быть указан в поле X-Share-Methods и иметь свой собственный раздел
[X-Share Method …] в desktop-файле.

Название блока [X-Share Method …] должно соответствовать названию в X-Share-Methods.
Например, строке X-Share-Methods=images; соотвествует раздел [X-Share Method images].

В блоке [X-Share Method …] в поле Capabilities указывается один или несколько mime-типов.
Несколько типов указываются через ";".

Если приложение обрабатывает список файлов, необходимо в блоке [X-Share Method …]
указать флаг SupportsMultipleFiles=yes.
Также этот флаг влияет на то, будет ли отображаться приложение в списке диалога «Поделиться»,
если пользователь хочет поделиться группой файлов.

Ключ ExecDBus используется для указания команды запуска приложения при запросе к соответствующей
службе D-Bus.
Дополнительный аргумент --dbus-launch позволяет определить, что запуск происходил именно
через D-Bus.
Совместно с ключом ExecDBus используются ключи X-Maemo-Service и X-Maemo-Method, содержащие
соответственно название службы и метод, вызываемый при обращении к службе.

## Пример Share: функция main

В функции main необходимо зарегистрировать службу D-Bus, которая будет использоваться
для активации приложения.

## Пример Share: ApplicationWindow

В ApplicationWindow для каждого X-Share Method необходимо добавить соответствующий ShareProvider.
