# Функции для переводов и QTranslator

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Выполнение переводов

Qt предоставляет поддержку для перевода приложений Qt C ++ и Qt Quick на локальные языки.
Менеджеры выпусков, переводчики и разработчики могут использовать инструменты перевода Qt для выполнения своих задач.
Инструменты перевода Qt, Qt Linguist, lupdate и lrelease установлены в подкаталоге bin базового каталога,
в который установлен Qt.

## Интернационализированный текст

Все читаемые человеком строки в приложении или сервисе должны быть встроены таким образом,
чтобы их можно было переводить.
В приложениях ОС Аврора возможности интернационализации Qt используются для обеспечения перевода
строк во время выполнения.

Всякий раз, когда приложение использует строковый литерал (текст в кавычках), который будет
представлен пользователю, убедитесь, что он обрабатывается функцией QCoreApplication::translate().
Всё, что нужно для этого, — использовать функцию tr() для получения переведённого текста.
Эта функция также используется для указания того, какие текстовые строки в приложении можно перевести.

Наиболее распространённый способ пометки строк  в QML — функция qsTr().

В разных языках слова располагаются в разном порядке, поэтому не рекомендуется создавать
предложения путём конкатенации слов и данных.
Вместо этого используйте % для вставки параметров в строки.
Например, есть строка с двумя числовыми параметрами %1 и %2.
Эти параметры вставляются с помощью функций .arg().

## QTranslator

Класс QTranslator обеспечивает поддержку интернационализации для вывода текста.
Объект этого класса содержит набор переводов с исходного языка на целевой язык.
QTranslator предоставляет функции для поиска переводов в файле перевода.
Файлы перевода создаются с использованием Qt Linguist.
Наиболее распространенное использование QTranslator - это: загрузить файл перевода, установить его
с помощью QCoreApplication::installTranslator и использовать его с помощью QObject::tr().

Обратите внимание, что переводчик должен быть создан до виджетов приложения.
Большинству приложений больше не нужно ничего делать с этим классом.
Другие функции, предоставляемые этим классом, полезны для приложений, работающих
с файлами переводчиков.

## Поиск переводов

Можно посмотреть перевод, используя translate() (как это делают tr()
и QCoreApplication::translate()).
Функция translate() принимает до трех параметров:

*	Контекст - обычно имя класса для вызывающей программы tr().
*	Исходный текст - обычно аргумент tr().
*	устранение неоднозначности - необязательная строка, которая помогает устранить неоднозначность
	разного использования одного и того же текста в одном и том же контексте.

## Использование нескольких переводов

В приложении может быть установлено несколько файлов перевода.
Переводы ищутся в обратном порядке, в котором они были установлены, поэтому в самом последнем
установленном файле перевода сначала выполняется поиск переводов, а в самом раннем файле
поиска - последний.
Поиск останавливается, как только перевод, содержащий соответствующую строку, найден.

Этот механизм позволяет определенному переводу быть "выбранным" или иметь приоритет над другими;
просто удалите переводчик из приложения, передав его в функцию QCoreApplication::removeTranslator()
и переустановите его с помощью QCoreApplication::installTranslator().
Тогда это будет первый перевод для поиска подходящих строк.
