# Объектная модель Qt

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Qt расширяет C++

Объектная модель стандартного C++ предоставляет весьма эффективную поддержку объектной парадигмы во время исполнения.
Но она является негибкой в некоторых проблемных областях.
Например, программирование графического интерфейса пользователя является областью, требующей
как эффективности во время исполнения, так и высокого уровня гибкости.
Qt предоставляет и то, и другое, объединяя скорость C++ и гибкость объектной модели Qt.
Многие из этих возможностей Qt реализованы с помощью стандартных приемов C++,
базирующихся на наследовании от QObject.
Остальным, подобно механизму связи между объектами и системе динамических свойств, требуется
Система мета-объектов, предоставляемая собственным Компилятором мета-объектов (moc) Qt.

## Клонирование идентификаторов

Некоторые из перечисленных дополнительных функций объектной модели Qt требуют, чтобы мы рассматривали объекты Qt как идентификаторы, а не как значения.
Значения копируются или назначаются; идентификаторы клонируются.
Клонирование означает создание нового идентификатора, а не точной копии старого.

Объект Qt...

может иметь уникальный метод QObject::objectName().
имеет местоположение в иерархии объектов.
может быть подключён к другим объектам Qt для отправки им сигналов или получения сигналов, отправляемых ими.
В него могут быть добавлены новые свойства во время выполнения, которые не объявлены в классе C++.

По этим причинам объекты Qt следует рассматривать как идентификаторы, а не как значения.
Идентификаторы клонируются, а не копируются и не назначаются, а клонирование идентификатора — более сложная операция, чем копирование или присвоение значения.
Поэтому у QObject и всех подклассов QObject (прямых или косвенных) отключены конструктор копирования и оператор присваивания.
