# Тесты по теме «Qt Network»

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Single choice

Есть ли возможность отправить запрос, используя только методы класса QNetworkRequest?

---

*	Возможность существует, ограничений нет.
*	**Нет, такой возможности нет совсем.**
*	Возможна, но с определенными ограничениями по содержанию запроса.

## Single choice

Какие функции выполняет класс QNetworkReply?

---

*	Позволяет приложению отправлять сетевые запросы.
*	Позволяет приложению получать ответы на сетевые запросы.
*	Содержит общую конфигурацию и настройки для посылаемых запросов.
*	**Содержит ответ сервера на наш запрос.**

## Single choice

Чем отличаются методы setHeader и setRawHeader класса QNetworkRequest?

---

*	**setHeader добавляет или изменяет заголовок типа QNetworkRequest::KnownHeaders header и его данные типа QVariant, а setRawHeader парсит название и значение заголовка из строк;**
*	setRawHeader добавляет или изменяет заголовок типа QNetworkRequest::KnownHeaders header и его данные типа QVariant, а setHeader парсит название и значение заголовка из строк.

## Single choice

Что случится, если методу attribute класса QNetworkReply дать в качестве аргумента атрибут,
который для объекта не задан?

---

*	Будет выброшено исключение.
*	**Будет возвращен  недействительный QVariant.**

## Single choice

Метод QNetworkReply::rawHeader(const QByteArray &headerName) возвращает исходное содержимое
заголовка headerName.
Как правильно обработать ситуацию, когда заголовок headerName оказывается не задан?

---

*	поймать и обработать исключение;
*	**перед вызовом rawHeader проверить, существует ли запрашиваемый заголовок при помощи метода hasRawHeader.**

## Multiple choice

Что можно сделать для получения данных от сервера, к которому мы подключились при помощи следующего кода:

```cpp
QNetworkAccessManager *manager = new QnetworkAccessManager();
QNetworkRequest request;
request.setUrl(QUrl("http://example.org"));
QNetworkReply *reply = manager->get(request);
```

---

*	**подписаться на сигнал finished объекта reply и обработать полученные от сервера данные;**
*	**подписаться на сигнал readyRead объекта reply и обрабатывать каждое новое поступление данных.**
*	подписаться на сигнал finished объекта manager и обработать полученные от сервера данные;
*	подписаться на сигнал readyRead объекта manager и обрабатывать каждое новое поступление данных.

## Multiple choice

Что содержит класс QNetworkReply?

---

*	**Данные**
*	**Метаданные**
*	**Заголовки**
*	Историю запросов.

## Single choice

Какие функции выполняет класс QNetworkRequest?

---

*	Позволяет приложению отправлять сетевые запросы.
*	Позволяет приложению получать ответы на сетевые запросы.
*	**Содержит общую конфигурацию и настройки для посылаемых запросов.**
*	Содержит ответ сервера на наш запрос.

## Single choice

Как получить объект запроса QNetworkRequest, результат которого содержится в QNetworkReply?

---

*	Это можно сделать только из объекта QNetworkRequest.
*	**Нужно вызвать метод request() объекта класса QNetworkReply.**
*	Нужно вызвать метод attribute() на объекте QNetworkReply.
*	Нужно вызвать метод get() на объекте QNetworkReply.

## Multiple choice

Какие классы используются для взаимодействия с сетевыми ресурсами?

---

*	**QNetworkAccessManager**
*	QNetworkRequestManager
*	QNetworkReplyManager
*	**QNetworkRequest**
*	QNetworkAccess
*	**QNetworkReply**

## Single choice

Какой сигнал отправит класс QNetworkReply, когда все данные будут загружены?

---

*	readyRead
*	**finished**
*	completed
