# Qt Network

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Модуль Qt Network

ОС Аврора обеспечивает поддержку сетевого функционала устройств, в частности, подключения
к сети Интернет, Bluetooth и NFC.

С этими технологиями разработчики могут взаимодействовать как используя модули Qt, например
QtNetwork, QtWebSockets и Qt Bluetooth, так и через соответствующие интерфейсы D-Bus.

В данном модуле рассматриваются прикладные программные интерфейсы для работы с подключениями
по TCP/IP и веб-сокетами.

Qt5 содержит модуль QtNetwork с набором классов C ++ для работы с TCP/IP. 

Чтобы работа с ним стала доступнаа, необходимо в pro файле приложения добавить модуль network,
а в spec файле добавить зависимость qt5-qtnetwork. 

Данный модуль содержит классы для работы с сетью на разных уровнях. 

Для работы непосредственно с TCP/IP и UDP используются классы QTcpSocket, QTcpServer и QUdpSocket.

Мы же поговорим о классах для работы на уровне http-запросов и ответов.

QNetworkAccessManager реализует механизм отправки запросов на сервер, QNetworkRequest cодержит общую
 конфигурацию и настройки для посылаемых запросов, а QNetworkReply ответ сервера на наш запрос.

Разрешение для приложений, работающих с сетью:

Internet - Передача данных и подключение к Интернету.

## QNetworkAccessManager — менеджер запросов

Координация сетевых операций выполняется классом QNetworkAccessManager.
После того как запрос был создан, этот класс используется для отправки и испускания сигналов,
сообщающих о его прогрессе.
Менеджер также координирует использование файлов cookie для хранения данных на клиенте,
запросов аутентификации и использования прокси.

Класс содержит методы для отправки HTTP запросов GET и POST PUT.
На вход эти методы принимают объекты класса QNetworkRequest и  возвращают новый объект
QNetworkReply, открытый для чтения. 

Метод deleteResource реализует запрос на удаление ресурса HTTP DELETE.

С помощью метода setCacheможно задать класс, который реализует дополнительные функции работы
с сетевым кэшем.
Например, постоянное хранение куки.

Метод setProxy устанавливает прокси-сервер, который будет использован в последующих запросах.

## QNetworkRequest — сетевой запрос

Сетевые запросы представлены классом QNetworkRequest, который также выступает в качестве общего
контейнера для информации, связанной с запросом, например информация заголовка и используемое
шифрование.
URL, указанный при построении объекта запроса, определяет используемый протокол.
В настоящее время поддерживаются HTTP, FTP и локальные URL-адреса файлов для загрузки.

Методы QNetworkRequest позволяют сформировать данную информацию - установить Url запроса,
заголовок, причем как из списка известных типов, так и произвольного, который может быть специфичен
для определенных протоколов. 

Метод setAttribute позволяет указать определенный атрибут запроса, который передан параметром code,
с помощью значения value, а setPriority устанавливает приоритет запроса.
Приоритет - это только рекомендация для  QNetworkAccessManager, которая не обязательно будет
использована.

## QNetworkReply —  ответ на запрос

QNetworkReply – класс, который содержит данные, метаданные и заголовки, связанные с ответом
на запрос, отправленный с помощью QNetworkAccessManager. 

Сигналы, предоставляемые QNetworkReply, могут использоваться для индивидуального контроля каждого
ответа.
QNetworkReply является подклассом QIODevice, поэтому ответы могут обрабатываться синхронно
или асинхронно.

Ссылку на исходный запрос можно получить с помощью метода request.

Кроме этого можно получить URL-адрес загруженных данных, значение заголовка известного
или произвольного типа, аттрибут, связанный с ключом code, а также данные об ошибке, если она была
найдена во время выполнения запроса. 

Основные сигналы QNetworkReply:

*	readyRead() - отправляется, когда новые данные становятся доступны для чтения;
*	error(QNetworkReply::NetworkError code) испускается, когда QNetworkReply обнаруживает ошибку при обработке;
*	sslErrors(const QList& QSslError& errors) выдается, если в сеансе SSL / TLS обнаружены ошибки
	во время настройки, включая ошибки проверки сертификата. Аргумент errors содержит список ошибок.

## Пример отправки запроса и получения ответа

Рассмотрим простой пример отправки GET запроса на адрес qt.io

Для этого создадим объект manager класса QNetworkAccessManager, а затем подготовим запрос, который
будем отправлять через него. 

Запросу request установим url qt.io и заголовок user-agent для отправки информации серверу о том,
каким браузером мы пользуемся.

Указатель на  возвращаемый ответ получим в результате выполнения метода get, и для него свяжем
сигналы ReadyRead, Error, SslErrors и соответствующие им слоты. 

Сигнал  readyRead будет отправлен, когда поступят данные.
Они будут обработаны методом  onReadyRead, который описан ниже.
В случае ошибки при обработке запроса будут выброшены сигналы error или slotSslErrors,
которые нужно обработать.

В методе описанного нами класса onReadyRead сначала мы получаем объект reply, затем при отсуствии
ошибок прочитаем и выведем его содержимое в консоль. 
