# Qt Linguist

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Работа с Qt Linguist

Qt Linguist – это инструмент для добавления переводов в приложения Qt.
После того как вы установили Qt, вы можете запустить Qt Linguist так же, как и любое другое
приложение на хосте разработки.

Главное окно Qt Linguist содержит строку меню и следующие виды:

*	Контекст (F6) для выбора из списка контекстов, в которых появляются строки для перевода.
*	Строки (F7) для просмотра переводимых строк, найденных в контексте.
*	Источники и формы (F9) для просмотра контекста, в котором используется текущая строка, если доступен исходный код для контекста.
*	Зона перевода для перевода строк.
*	Фразы и догадки (F10) для просмотра возможных переводов для текущей строки.
*	Предупреждения (F8) для просмотра переведенных строк, которые не проходят проверочные тесты.
*	Область перевода (1) всегда видна.
	Чтобы показать или скрыть другие виды, выберите «Вид»> «Виды» или используйте сочетания клавиш,
	перечисленные выше.
	Вы можете перетащить представления за их заголовки и расположить их вокруг области перевода
	или даже за пределами главного окна.

## Переводы строк

Вы открываете исходные (TS) файлы в Qt Linguist для перевода.
Файлы TS - это читаемые человеком файлы XML, содержащие исходные фразы и их переводы.
Файлы TS обычно создаются и обновляются с помощью lupdate.
Вы также можете использовать Qt Linguist для перевода файлов в международном формате файлов
обмена XML-локализацией (XLIFF), которые генерируются другими программами.
Однако для стандартных проектов Qt используется только формат файла TS.
Qt Linguist отображает целевой язык в области перевода и соответствующим образом адаптирует
количество полей ввода для множественных форм.
Когда вы открываете несколько файлов TS для одновременного перевода, поля комментариев Переводчик
отображаются для каждого языка.
Если разработчик предоставляет комментарий  неоднозначности, он отображается в поле «Комментарии разработчика».

## Процесс перевода строк

Чтобы перевести строки:

1.	Выберите Файл> Открыть, чтобы загрузить файл TS.
2.	Выберите контекст в представлении «Контекст», чтобы загрузить переводимые строки, найденные
	в этом контексте, в представление «Строки».
3.	Выберите строку, чтобы скопировать ее в качестве исходного текста в области перевода.
	Пробелы в исходном тексте визуализируются, так что вы можете видеть расстояние, необходимое в тексте.
4.	Введите перевод текущей строки в поле Перевод.
5.	Вы также можете выбрать существующий перевод в представлении «Фразы и догадки», 
	дважды щелкнув по нему.
	Фразы читаются из словарей фраз, и предположения представляют собой существующие переводы похожих фраз в файле TS.
6.	При необходимости введите комментарий, который будут читать другие переводчики, в поле Комментарий переводчика.
7.	Чтобы принять перевод, нажмите Ctrl + Enter или щелкните иконку слева от выбранной исходной строки в списке строк..
8.	Выберите Файл> Сохранить, чтобы сохранить вашу работу.
	Повторяйте этот процесс до тех пор, пока все строки в списке не будут помечены как
	(Принятые / Правильные) или (Принятые / Предупреждения).
	Затем выберите следующий контекст и продолжите.

## Работа с переводами строк

Чтобы просмотреть количество слов и символов в исходном тексте и переведенном тексте,
выберите «Просмотр»> «Статистика».
Выберите File> Release, чтобы создать файл QM с тем же базовым именем, что и текущий исходный файл перевода.
Средство командной строки lrelease выполняет ту же функцию для всех исходных файлов перевода приложения.

Если вы хотите оставить перевод, нажмите Ctrl + L (Next незаконченный), чтобы перейти к следующему
незаконченному переводу.
Для перехода к следующему переводу (законченному или незаконченному) нажмите Shift + Ctrl + L.
Вы также можете перемещаться с помощью меню перевода.
Если вы хотите полностью перейти в другой контекст, щелкните контекст, над которым вы хотите
работать, в списке «Контекст», затем щелкните исходный текст в представлении «Строки».

## Фразы с несколькими переводами

Одна и та же фраза может встречаться в двух или более контекстах без конфликта.
Как только фраза была переведена в одном контексте, Qt Linguist отмечает, что перевод был выполнен,
и когда переводчик достигает более позднего появления той же фразы, Qt Linguist предоставляет
предыдущий перевод в качестве возможного кандидата для перевода в представлении «Фразы и догадки».

Если фраза встречается более одного раза в определенном контексте, она отображается только один раз
в представлении «Контекст», и перевод применяется к каждому вхождению в контексте.
Если одну и ту же фразу нужно переводить по-разному в одном и том же контексте, разработчик должен
предоставить отличительный комментарий для каждого вхождения фразы.
Если такие комментарии используются, дублированные фразы появляются в представлении контекста.
Комментарии разработчика отображаются в области перевода на голубом фоне.

## Обработка пронумерованных аргументов

Некоторые фразы содержат пронумерованные аргументы.
Нумерованный аргумент - это заполнитель, который будет заменен текстом во время выполнения.
Нумерованный аргумент появляется в исходной строке в виде знака процента, за которым следует цифра.
Рассмотрим пример: After processing file %1, file %2 is next in line.
В этой строке для перевода %1 и %2 являются пронумерованными аргументами.
Во время выполнения %1 и %2 будут заменены на первое и второе имена файлов соответственно.
Те же пронумерованные аргументы должны появляться в переводе, но не обязательно в том же порядке.

Немецкий перевод строки может перевернуть фразы, например: Datei %2 wird bearbeitet, wenn Datei %1 fertig ist. 
Оба пронумерованных аргумента появляются в переводе, но в обратном порядке. %i всегда будет заменяться
одним и тем же текстом в строках перевода, независимо от того, где аргумент i появляется
в последовательности аргументов в исходной строке.

Использование пронумерованных аргументов часто сопровождается использованием множественного
числа в исходном тексте.
Во многих языках форма текста будет зависеть от отображаемого значения, и требуется более одного перевода.
Если разработчики правильно разметили исходный текст, в области перевода будут доступны поля
для каждой из возможных форм множественного числа.

## Изменение целевой локали

Вы можете явно указать информацию о локали в меню «Правка»> «Настройки файла перевода».
Если целевой язык и страна не указаны явно при открытии исходного файла перевода, Qt Linguist
пытается вычислить их из имени исходного файла перевода.
Для этого необходимо, чтобы файлы перевода придерживались следующего соглашения об именах файлов:
appname_language [_country] .ts, где:

*	language - это код языка ISO 639 в нижнем регистре;
*	country - это двухбуквенный код страны ISO 3166 в верхнем регистре.

Если эта попытка определить целевой язык и страну не удалась, откроется окно «Настройки файла перевода».
Например, app_de.ts устанавливает целевой язык на немецкий, а app_de_ch.ts устанавливает целевой язык
на немецкий, а целевую страну – на Швейцарию.
Это также помогает автоматически загружать переводы для текущей локали.

## Выбор контекста для перевода

В представлении «Контекст» перечислены контексты, в которых отображаются переводимые строки.
В столбце «Контекст» перечислены имена контекста в алфавитном порядке.
Каждый контекст – это имя подкласса QObject.
Также может существовать контекст для самого QObject, который содержит строки, переданные
статической функции QObject::tr().
Также может существовать <безымянный контекст>, который содержит строки, которые не входят в подкласс QObject.

Следующие слова обозначают текущее состояние перевода для каждого контекста:

*	Accepted/Correct Все строки в контексте были переведены, и все переводы прошли проверочные тесты.
*	Accepted/Warnings Все строки в контексте были переведены или помечены как переведенные, 
	но по крайней мере один перевод не прошел проверочные тесты.
	В представлении Strings вы можете увидеть, какая строка не прошла тест.
*	Not Accepted По крайней мере, одна строка в контексте не была переведена или не помечена как переведенная.
*	Obsolete Ни одна из переведенных строк больше не появляется в контексте.
	Обычно это означает, что сам контекст больше не существует в приложении.

Столбец Предметы отображает общее количество переводимых строк в контексте и количество
переведенных строк, разделенных косой чертой (/).
Если числа равны, все переводимые строки в контексте имеют переводы.

## Состояние перевода для строки

В представлении «Строки» перечислены все переводимые строки, найденные в текущем контексте,
и состояние их перевода.
Выбор строки делает эту строку текущей строкой в области перевода.
Нажмите на иконку перед строкой, чтобы изменить ее состояние приема перевода.
Галочка, зеленая или желтая, означает, что строка была переведена и перевод принят.
Знак вопроса означает, что перевод не был принят или строка не имеет перевода.

Следующие слова указывают текущее состояние перевода для каждой строки:

*	Accepted/Correct Исходная строка имеет перевод (возможно, пустой).
	Пользователь принял перевод, и перевод проходит все проверочные тесты.
	Если перевод пуст, пользователь решил оставить его пустым.
	Щелкните иконку, чтобы отменить принятие перевода и уменьшить число принятых переводов
	в столбце «Элементы» в представлении «Контекст» графического интерфейса на 1.
	Состояние сбрасывается на  Not Accepted, если строка имеет перевод, или на No Translation,
	если перевод строки пустой.
	Если lupdate изменяет содержимое строки, ее состояние принятия автоматически сбрасывается
	на Not Accepted.
*	Accepted/Warnings Пользователь принял перевод, но перевод не прошел все проверочные тесты.
	Сбои проверочного теста отображаются в представлении «Предупреждения».
	Нажмите на иконку, чтобы отменить принятие перевода.
	Состояние сбрасывается до Validation Failures, и количество принятых переводов в столбце «Элементы»
	представления «Контекст» уменьшается на 1.
*	Not Accepted Строка имеет перевод, который проходит все проверочные тесты, но пользователь
	еще не принял перевод.
	Нажмите на значок или нажмите Ctrl + Enter, чтобы принять перевод.
	Состояние сбрасывается до Accepted/Correct, а количество принятых переводов в столбце «Элементы»
	представления «Контекст» увеличивается на 1.
*	No Translation Строка не имеет перевода.
	Нажмите на иконку, чтобы принять пустой перевод в любом случае.
	Состояние сбрасывается до Accepted/Correct, а количество принятых переводов в столбце «Элементы»
	представления «Контекст» увеличивается на 1.
*	Validation Failures Строка имеет перевод, но перевод не проходит все проверочные тесты.
	Сбои валидационных испытаний отображаются в представлении «Предупреждения».
	Нажмите на иконку или нажмите Ctrl + Return, чтобы принять перевод даже при сбое проверки.
	Мы рекомендуем отредактировать перевод, чтобы устранить причины сбоев валидации.
	Состояние будет автоматически сброшено до Not Accepted, когда все сбои будут устранены.
*	Obsolete Строка устарела. Он больше не используется в контексте.

## Просмотр строк в контексте

Если исходные файлы, содержащие переводимые строки, доступны для Qt Linguist, представление
Sources and Forms отображает исходный контекст текущей строки в представлении Strings.
Строка исходного кода, содержащая текущую строку, должна быть показана и выделена.
Если файл, содержащий исходную строку, не найден, отображается ожидаемый абсолютный путь к файлу.

Если исходный контекст показывает неправильную исходную строку, это, вероятно, означает, что файл
перевода не синхронизирован с исходными файлами.
Синхронизируйте его средствами lupdate.

## Повторное использование переводов

Если переведенный текст похож на исходный текст, выберите «Перевод»> «Копировать из исходного текста»
(или нажмите Ctrl + B), чтобы скопировать исходный текст в область перевода.
В Qt Linguist словари фраз используются для предоставления общего набора переводов для обеспечения согласованности.
Словарь фраз - это набор исходных фраз, целевых (переведенных) фраз и необязательных определений.
Как правило, один словарь фраз создается для языка и семейства приложений.
Словари фраз могут также использоваться, чтобы избежать дублирования усилий, поскольку переводы
для семейства приложений могут быть произведены один раз в словаре.

Если текущая строка в представлении «Строки» отображается в одном или нескольких загруженных
словарях фраз, текущая строка и переводы ее словарей фраз отображаются в представлении «Фразы и догадки».
Если текущая строка совпадает или похожа на другую строку, которая уже была переведена, эта другая строка
и ее перевод также будут перечислены в этом представлении.
Чтобы скопировать перевод из представления «Фразы и догадки» в область перевода, дважды щелкните его
или выберите его и нажмите клавишу «Ввод».

## Пакетный перевод

Используйте функцию пакетного перевода Qt Linguist для автоматического перевода исходных текстов,
которые также находятся в словаре фраз.
Чтобы указать, какие словари фраз использовать в каком порядке в процессе пакетного перевода,
выберите «Редактирование»> «Пакетный перевод».
Вы можете указать, следует ли рассматривать только записи без текущего перевода, и должны ли
записи с пакетным переводом быть помечены как принятые.

## Создание и редактирование словарей фраз [1]

Файлы фраз - это файлы XML, удобные для чтения человеком и содержащие стандартные фразы
и их переводы.
Эти файлы создаются и обновляются Qt Linguist и могут использоваться любым количеством проектов и приложений.
Чтобы создать новый словарь фраз, выберите «Фразы»> «Новый словарь фраз».

*	Чтобы открыть словарь фраз, выберите Фразы> Открыть словарь фраз, а затем выберите файл фраз Qt
	(.qph) для открытия.
*	Для просмотра и изменения открытых словарей фраз выберите Фразы> Редактировать словарь фраз.
*	Чтобы добавить новую фразу, выберите «Новая запись» (или нажмите Alt + N) и введите новую
	исходную фразу, перевод и опционально определение.
	Это полезно для различения разных переводов одной и той же исходной фразы.
*	Чтобы добавить перевод, над которым вы работаете, в текущий словарь фраз, выберите «Фразы»>
	«Добавить в словарь фраз» или нажмите Ctrl + T.
	Если загружено несколько словарей, вы должны выбрать один.

## Создание и редактирование словарей фраз [2]

Если вы обнаружите ошибку в записи словаря фраз, которая отображается в представлении «Фразы и догадки»,
вы также можете отредактировать ее на месте, щелкнув правой кнопкой мыши на записи и выбрав «Редактировать».
После исправления ошибки нажмите Return, чтобы выйти из режима редактирования.

Чтобы удалить фразу, выберите ее в списке «Исходная фраза», а затем выберите «Удалить запись».

Чтобы распечатать открытый словарь фраз, выберите Фразы> Распечатать словарь фраз.

## Проверка перевода

Qt Linguist предоставляет следующие проверочные тесты для переводов.

*	Проверка пунктуации выявляет различия в конечной пунктуации между исходными
	и переведенными фразами, когда это может быть значительным.
	Например, предупреждает, если исходная фраза оканчивается многоточием, восклицательным знаком
	или вопросительным знаком, а переведенная фраза - нет, и наоборот.
*	Проверка фраз выявляет исходные фразы, которые также есть в словаре фраз, но перевод которых
	отличается от перевода в словаре.
*	Проверка маркера места определяет, используются ли одинаковые переменные (например,%1,%2)
	как в исходном тексте, так и в переводе.
*	Чтобы включить или отключить проверочные тесты, выберите Валидация или используйте кнопки панели инструментов.
*	Непринятые строки, не прошедшие проверку, помечаются значком «Ошибки проверки» в представлении
	«Строки».
	Принятые строки помечены как Accepted/Warnings.
*	Если вы выключите проверку, а затем включите ее позже, Qt Linguist перепроверяет все фразы
	и помечает все фразы, которые не прошли проверку.
*	Если перевод, введенный для текущей строки, не проходит ни один из активных проверочных тестов,
	ошибки отображаются в представлении «Предупреждения».
	Первое из этих сообщений об ошибках также отображается в строке состояния в нижней части главного окна.
*	Представляются только результаты активных проверочных испытаний.

## Создание и редактирование словарей фраз [3]

Вы можете загружать и редактировать несколько файлов перевода одновременно.
На скриншоте показаны загруженные файлы перевода на польский и японский языки.

В области перевода есть области редактирования текста как для польского, так и для японского языков,
которые имеют цветовую кодировку для облегчения разделения.
Представление «Контекст» и представление «Строки» имеют два столбца состояния вместо одного,
имеющие цветовую кодировку с одинаковыми цветами.
Крайний левый столбец относится к самой верхней языковой области (на польском языке выше) в области
перевода, а самый правый столбец относится к нижней языковой области.

Столбец «Элементы» в представлении «Контекст» объединяет значения для обоих языков.
Если количество переводимых строк не совпадает с количеством принятых строк, либо на одном,
либо на обоих языках есть строки, которые необходимо перевести или принять.
Представление «Строки» показывает состояние принятия перевода каждой строки для каждого языка.
