# Qt Application и цикл событий

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QGuiApplication

Класс QGuiApplication ответственен за поток управления и основные настройки приложения с графическим интерфейсом.

QGuiApplication содержит основной цикл событий, в котором обрабатываются и отправляются все события из оконной системы и других источников. Он также отвечает за инициализацию и завершение работы приложения, а также обеспечивает управление сеансами. Кроме того, QGuiApplication обрабатывает большинство общесистемных и общеприкладных настроек.

Для любого приложения с графическим интерфейсом, использующего Qt, существует ровно один объект QGuiApplication.

Объект QGuiApplication доступен через функцию instance(), которая возвращает указатель, эквивалентный глобальному указателю qApp.

## Основные задачи QGuiApplication

Основные задачи QGuiApplication:

*	Инициализация приложения с системными настройками, такими как palette(), font() и styleHints(). QGuiApplication отслеживает эти свойства на случай, если эти настройки изменятся на устройстве глобально.
*	Обработка событий: получение событий от базовой оконной системы и отправка их соответствующим компонентам. Можно отправлять собственные события окнам с помощью sendEvent() и postEvent().
*	Обработка общих аргументов командной строки и установка внутреннего состояния в соответствии с ними.
*	Локализация строк, видимых пользователю, осуществляется с помощью translate().
*	Информация об окнах приложения.
*	Управление обработкой курсора мыши в приложении.
*	Поддержка сложного управления сеансами. Это позволяет приложениям корректно завершать работу при выходе пользователя из системы, отменять процесс завершения работы, если завершение работы невозможно, и даже сохранять всё состояние приложения для будущего сеанса. 

Поскольку объект QGuiApplication выполняет так много инициализации, его необходимо создать до создания любых других объектов, связанных с пользовательским интерфейсом. QGuiApplication также работает с общими аргументами командной строки. Поэтому обычно рекомендуется создать его до того, как в самом приложении будет выполнена какая-либо интерпретация или изменение argv.

## Пример стартовой точки приложения

На слайде представлен пример стартовой точки приложения, созданный из шаблона Qt Creator.
QGuiApplication принимает на вход аргументы командной строки.
Объект этого класса создаётся самым первым.

Чтобы запустить приложение, вызывается метод exec у QGuiApplication.
Результат его работы считается результатом всего приложения.
