# QObject и QGadget, макросы, свойства

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Q_GADGET

Макрос Q_GADGET — это облегчённая версия макроса Q_OBJECT для классов, которые не наследуются
от QObject, но все же хотят использовать некоторые возможности метаобъектной системы.
Как и макрос Q_OBJECT, он должен находиться в приватном разделе определения класса.

Классы, помеченные Q_GADGET, могут содержать Q_ENUM, Q_PROPERTY и Q_INVOKABLE,
но не могут иметь сигналы или слоты.

## Регистрация класса для QML

Допустим, у нас есть интерфейс приложения на QML и C++ класс с логикой работы. 
Нам необходимо соединить это вместе и позволить обращаться к C++ классу внутри QML. 
Начнем с нашего C++ класса. 
Самое первое, что нам нужно сделать для того чтобы он был доступен из QML — это унаследовать его
от QObject либо любого другого наследника этого самого QObject.
Второе — добавить макрос Q_OBJECT в описание класса.
Он необходим для работы механизма сигналов и слотов, а также для возможности описания свойств.

Далее нужно зарегистрировать наш класс в QML, для этого нам нужно дополнить функцию main(),
которая создается в Qt Creator автоматически при создании нового QtQuick проекта.
Туда необходимо добавить вызов шаблонной функции qmlRegisterTypes().

В качестве параметра шаблона в qmlRegisterTypes() указывается имя нашего созданного класса.
Функция имеет 4 параметра: ModuleName — Имя импортируемого модуля, 1 и 0 — версия модуля (1.0),
MyClass — имя класса, по которому будем обращаться к нему внутри QML.

Для использования нашего класса в QML необходимо импортировать описанный выше модуль как показано на слайде.
Теперь мы можем создавать QML-объекты, используя имя нашего класса. Задавать id для объекта
мы можем, как и в случае с любым стандартным QML-объектом.

## Регистрация свойств

Система свойств Qt позволяет сохранять в объектах индивидуальные свойства в дополнение к обычным
данным-членам объекта или оборачивая их.
Доступ к свойствам можно получить для любого Qt-объекта с помощью системы мета-объектов. 
Класс, наследующий QObject, может содержать объявление свойства при помощи макроса Q_PROPERTY().

Макрос описан на слайде. 
Тип и имя свойства, а также метод, возвращающий значение свойства, являются обязательными параметрами. 
Все остальные, помеченные квадратными скобками, являются необязательными.
Методы, определенные параметрами READ, WRITE и RESET могут быть виртуальными либо унаследованными
от базового класса.

Многие определенные в Qt объекты поддерживают различные свойства, которые позволяют управлять их поведением.
При этом сам механизм свойств позволяет контролировать данные свойства единообразным образом.
С практической точки зрения свойства понадобятся в ситуации, когда необходимо использовать C++ объект
в QML коде и обращаться к его полям.

## Регистрация перечислений

Макрос Q_ENUM регистрирует тип enum в системе мета-объектов.
Он должен быть помещен после объявления enum в класс, который имеет макрос Q_OBJECT.

Например, в классе TextProcessor определяется перечисление.

Помните, что значения перечисления хранятся как int в системе мета-объектов.
Регистрация перечислений со значениями вне диапазона значений, допустимых для int, приведет
к переполнению и потенциально неопределенному поведению при доступе к ним через систему мета-объектов.
Например, QML осуществляет доступ к зарегистрированным перечислениям через систему мета-объектов.

## Регистрация методов

Для того, чтобы метод класса был доступен в QML, необходимо добавить к определению метода макрос Q_INVOKABLE.
Также вместо определения метода макросов, можно поместить метод в секцию public slots;
и тогда метод тоже будет доступен в QML. 

Обычно макросом помечаются методы, не связанные со свойствами, но, выполняющие некоторые
действия в интерфейсе. 
