# Сигналы и слоты

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Создание и обработка сигналов

Собственным QML-компонентам можно добавлять сигналы.
Сигналы служат для того, чтобы сообщить какому-либо объекту о каком либо событии.
Для объявления сигнала необходимо использовать ключевое слово signal, затем указывать название
сигнала и список параметров с типами в скобках.
Для того, чтобы инициировать сигнал, необходимо вызвать его как обыкновенный метод.
Для обработки сигналов существуют соответствующие свойства, которым присваиваются обработчики.
Данные свойства начинаются с приставки on, далее идёт название самого сигнала с большой буквы.
Внутри тела обработчика доступны передаваемые свойства по названиям, указывающимся при объявлении сигнала.

Данный пример изменяет цвет кнопки после нажатия на неё.
Сигнал customButtonClicked() используется для того, чтобы уведомить о нажатии.
В качестве параметра передаётся новый цвет кнопки.
Данный параметр используется в обработчике для вывода нового цвета в консоль.

## Подключение и отключение обработчиков

Также обработчики сигналов можно подключать с помощью метода connect().
Данный метод вызывается на объекте сигнала объекта.
Следует обратить внимание, что обращение к сигналу производится без использования приставки on.
Метод-обработчик может принимать параметры от сигнала (в данном примере объект mouse).

Отключаются сигналы аналогичным образом, но с использованием метода disconnect(), которому
передаётся функция-обработчик, подключенная ранее.
 
## Сигналы изменения свойств

У каждого свойства, объявленного в QML есть обработчик изменения значения.
Он начинается с приставки on, как обыкновенный сигнал, далее идёт название свойства с большой буквы
и заканчивается словом Changed.

В текущем примере мы можем использовать сигнал изменения цвета для того, чтобы выводить его код на консоль.
 
## Connections — обработчик сигналов

Объектам можно устанавливать обработчики событий с помощью объекта Connections.
Он позволяет задать обработчик внутри своего тела, а целевой объект с помощью свойства target.
Данный способ установки обработчиков полезен, если объект объявлен глобально и и необходимо указать
какой-то обработчик на какой-либо странице.
В этом случае невозможно установить обработчик в месте определения, поэтому используется
объект Connections.
По умолчанию объект будет выбрасывать runtime исключение, если производится подключение
к несуществующему сигналу.
Чтобы игнорировать такие сигналы, необходимо установить свойству ignoreUnknownSignals значение true.
