# Свойства

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Описание свойств и методов

Определение новых свойств в QML компонентах осуществляется с помощью приведенной на слайде конструкции.
В качестве propertyType могут выступать такие типы как int, bool, string, var (универсальный
тип переменной), массивы и словари, а также типы предоставляемые модулем QtQuick такие, как date, color.
Полный список можно посмотреть в документации.
Конструкция позволяет проинициализировать свойство при объявлении.

## Определение свойств

Свойства, определенные для корневого объекта, доступны  для чтения и изменения другими компонентами извне.
Помимо стандартных свойств, определенных для корневого элемента, QML позволяет добавлять
собственные свойства.
Для них также доступен механизм связывания.
Для добавления нового свойства необходимо указать его название и тип.
Название должно быть уникальным внутри компонента.
Для свойства может быть определено значение по умолчанию (опционально).
Пример демонстрирует добавление свойства currentImage типа строки со значением
по умолчанию "default-image.png".

## alias-свойства

Кроме определения свойств, которые хранят непосредственно какое-либо значение, средства QML
позволяют создавать alias (псевдо свойства), которые могут быть связаны с другими существующими свойствами.
Операция чтения или записи такого свойства осуществляется как чтение или запись связанного с ним свойства.
Синтаксис добавления alias похоже на объявление обычного свойства.
Так как псевдо свойство имеет тип аналогичный связанному свойству, явное указание типа заменено
на ключевое слово alias.
Вместо значения по умолчанию для alias необходимо обозначить свойство, на которое оно ссылается.
При этом нужно указать идентификатор объекта внутри компонента, а затем через точку его свойство.

Пример демонстрирует добавление alias buttonText для свойства text внутри элемента Text{}.

## Свойства с параметром default

Определение объекта может иметь одно свойство по умолчанию. Свойство по умолчанию — это свойство, которому присваивается значение, если объект объявлен как вложенный в другом объекте без объявления его как значения конкретного свойства.

Объявление свойства с необязательным ключевым словом default помечает его как свойство по умолчанию. Например, предположим, что есть файл MyLabel.qml со свойством по умолчанию someText.

Значение someText можно присвоить в определении объекта MyLabel.

Это имеет тот же эффект, что и прямое присваивание.

Однако, поскольку свойство someText отмечено как свойство по умолчанию, нет необходимости явно назначать этому свойству объект Text.

Дочерние объекты можно добавлять к любому основанному на элементах типу без явного добавления их в свойство children. Это связано с тем, что свойством по умолчанию элемента Item является его свойство data, и любые элементы, добавленные в этот список для элемента Item, автоматически добавляются в его список дочерних элементов.

## Привязывание свойств

К значению свойства можно обращаться по его имени propertyName из кода,
определённого в propertyOwner - владельце свойства.

В другом объекте к значению свойства можно обращаться по id владельца свойства и имени свойства,
написанных через точку.

Свойство с привязкой автоматически обновляется по мере необходимости. Однако, если свойству впоследствии будет присвоено статическое значение из оператора JavaScript, привязка будет удалена. Если предполагается установить новое соотношение, то новое выражение привязки необходимо обернуть в функцию Qt.binding().

## Binding — привязки к свойствам

Привязки свойств приводят к зависимости между свойствами различных объектов.

*	target : Объект для обновления.
*	value : Значение, которое будет установлено для целевого объекта и свойства.
	Это может быть константа (что не очень полезно) или связанное выражение.
*	property :  Свойство для обновления.
	Это может быть и групповое свойство.
*	when : Это свойство сохраняется, когда привязка активна.
	Ему должно присваиваться выражение, которое оценивается как true, если вы хотите,
	чтобы привязка была активной.
