# Массивы

Copyright&nbsp;©&nbsp;2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Массивы в JS

Массив (Array) в JavaScript является глобальным объектом, который используется для создания массивов; которые представляют собой высокоуровневые спископодобные объекты.

Массив в JavaScript инициализируется с помощью переданных элементов, за исключением случая, когда в конструктор Array передаётся один аргумент и этот аргумент является числом. Стоит обратить внимание, что этот особый случай применяется только к JavaScript-массивам, создаваемым с помощью конструктора Array, а не к литеральным массивам, создаваемым с использованием скобочного синтаксиса.

## Работа с массивами

*	Создание массива. Пример на слайде.
*	Доступ к элементу массива по индексу. Пример на слайде.
*	Итерирование по массиву. Пример на слайде.

## Работа с элементами массива

*	Добавление элемента в конец массива. Пример на слайде.
*	Удаление последнего элемента массива. Пример на слайде.
*	Удаление первого элемента массива. Пример на слайде.
*	Добавление элемента в начало массива. Пример на слайде.
*	Поиск номера элемента в массиве. Пример на слайде.

## Методы работы с массивом

Array.of() 
Создаёт новый экземпляр Array из любого количества аргументов, независимо от их количества или типа.

Методы изменения
Эти методы изменяют массив:
Array.prototype.fill() 
Заполняет все элементы массива от начального индекса до конечного индекса указанным значением.
Array.prototype.reverse()
Переворачивает порядок элементов в массиве — первый элемент становится последним, а последний — первым.
Array.prototype.sort()
Сортирует элементы массива на месте и возвращает отсортированный массив.

Методы доступа
Эти методы не изменяют массив, а просто возвращают его в ином представлении.
Array.prototype.concat()
Возвращает новый массив, состоящий из данного массива, соединённого с другим массивом и/или значением (списком массивов/значений).
Array.prototype.includes() 
Определяет, содержится ли в массиве указанный элемент, возвращая, соответственно, true или false.
Array.prototype.join()
Объединяет все элементы массива в строку.
Array.prototype.toString()
Возвращает строковое представление массива и его элементов. 

## Методы обхода

Методы обхода
Некоторые методы принимают в качестве аргументов функции, вызываемые при обработке массива. Когда вызываются эти методы, достаётся длина массива, и любой элемент, добавленный свыше этой длины изнутри функции обратного вызова не посещается. Другие изменения в массиве (установка значения или удаление элемента) могут повлиять на результаты операции, если изменённый элемент метод посещает после изменения. Хотя специфическое поведение этих методов в таких случаях хорошо определено, вы не должны на него полагаться, чтобы не запутывать других людей, читающих ваш код. Если вам нужно изменить массив, лучше вместо этого скопируйте его в новый массив.

Array.prototype.filter()
Создаёт новый массив со всеми элементами этого массива, для которых функция фильтрации возвращает true.
Array.prototype.find() 
Возвращает искомое значение в массиве, если элемент в массиве удовлетворяет условию проверяющей функции или undefined, если такое значение не найдено.
Array.prototype.map()
Создаёт новый массив с результатами вызова указанной функции на каждом элементе данного массива.
Array.prototype.reduce()
Применяет функцию к аккумулятору и каждому значению массива (слева-направо), сводя его к одному значению.
