# Дочерние объекты

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Взаимное расположение объектов

Объекты располагаются относительно объектов визуального родителя, т.е. тех, в которые они вложены. Отсчёт значений свойств x и y ведётся относительно верхнего левого угла визуального родителя.

Концепция визуального родителя отличается от концепции родителя QObject. Визуальный родитель элемента может не совпадать с его родительским объектом.

Свойство parent указывает на визуального родителя. Свойство children содержит список визуальных дочерних элементов данного элемента.

## Обрезка

Свойство clip определяет, включена ли обрезка. Значение по умолчанию — false.

Если обрезка включена, элемент будет обрезать свою отрисовку, а также отрисовку своих дочерних элементов по ограничивающему прямоугольнику.

Если обрезка отключена, содержимое объектов и их дочерних компонентов может выходить за их границы.

Элементы обрезаются по границам окна.

Обрезки Flickable-элемента (или другого контейнера) часто можно избежать, организовав пользовательский интерфейс таким образом, чтобы непрозрачные элементы закрывали области вокруг Flickable-элемента, а также полагаться на края окна для отсечения всего остального.

## Порядок отрисовки

Элементы пользовательского интерфейса отрисовываются рекурсивно.
Сначала отрисовывается корневой элемент, затем первый дочерний элемент и его дочерние элементы,
затем второй и так далее.
Получается обход дерева в прямом порядке.

Порядок отрисовки элементов можно изменять с помощью z-координаты.
Она позволяет задать высоту элемента относительно родительского элемента и соседних.
Чем выше значение, тем позднее будет отрисован элемент относительно других.

## Пример с наложением объектов

В данном примере дочерние элементы отрисовываются один за другим.

## Пример z-координаты

Пример, похожий на описанный ранее, но у красного прямоугольника установлено значение z-координаты
равным 1.
Так как у синего прямоугольника значение этой координаты по умолчанию установлено равным 0,
то он будет отрисован раньше красного.

Стоит заметить, что z-координата влияет на отображение данного элемента только относительно
соседних и родительского.
В данном примере зелёному прямоугольнику установлено значение z-координаты равное -1,
что меньше значения z-координаты синего.
Но эти два прямоугольника не являются соседними, и зелёный не является родительским для синего,
поэтому установка координаты в данном случае не влияет на порядок отрисовки.
