# Базовые понятия и типы

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Qt Quick — технология быстрой разработки

Интрерфейсы на Qt удобно создавать с помощью языка разметки QML.
Он находится в модуле Qt Quick.

QtQuick предоставляет классы для работы с канвой, классы для создания визуальных компонентов
ввода/вывода информации.
Кроме этого, модуль содержит в себе средства для создания анимаций и позиционирования элементов,
а также классы создания моделей данных и работой с базой данных.

Интерфейсы для десктопных приложений можно создавать с помощью QtQuick Controls, для мобильных
приложений для платформы ОС Аврора — с помощью Silica.

Silica поставляется внутри Аврора SDK. Компоненты Silica позволяют создавать приложения, внешний
вид и поведение которых соответствуют принципам ОС Аврора.
К особенностям платформы можно отнести управление жестами, дополнительные элементы, уникальные
для ОС: вытягиваемые сверху и снизу меню, обложка свернутых приложений.

## QML: вложенные объекты, свойства, привязки

Рассмотрим структуру интерфейса приложения на примере первой страницы.
Страница состоит из различных элементов: как визуальных (Label, PageHeader), так и не визуальных
(Page, Column и др.).
Для каждого элемента доступен свой определенный набор свойств.
На слайде можно увидеть примеры таких свойств, как width, spacing, text, color и др.
Стоит обратить внимание на свойство id, которое позволяет идентифицировать компонент среди других
объектов и ссылаться на его свойства.
Оно должно иметь уникальное значение внутри области видимости.

Свойству можно присвоить как константное, так и динамически вычисляемое значение.
Механизм связывания (property binding) позволяет устанавливать связи между свойствами одного
или различных объектов.
При изменении значения соответствующих свойств, зависимое свойство автоматически обновится согласно
установленной связи.

## Элементы компонента QML

У всех компонентов QML имеются общие элементы.

*	id — уникальный идентификатор для обращения.
*	Properties — набор свойств заданных типов, обладающих названиями и значениями.
*	Methods — методы объектов, написанные на JavaScript.
*	Signals — уведомления от компонентов QML.
*	Signal Handlers — функции обработки сигналов.
*	Nested objects — вложенные или дочерние компоненты QML.

## Глоссарий терминов QML

Основные термины, которые используются в QML-разработке.

*	Type — базовый тип или тип объекта QML.
	*	Basic Type — простой тип данных, например int, string и bool.
	*	Object Type — тип объекта может быть создан механизмом QML.
*	Object — экземпляр типа объекта QML.
*	Component — шаблон для создания объекта или дерева объектов.
*	Document — самостоятельная часть кода QML.
	Находится в отдельном файле.
	*	Начинается с одного или нескольких операторов импорта.
	*	Содержит одно объявление объекта верхнего уровня.
*	Binding — выражение JS, присвоенное и «привязанное» к свойству.

## Базовые типы QML

Базовые типы данных, используемые в QML.

*	bool — логическое значение (true или false).
*	int — целое число.
*	real — число с плавающей точкой.
*	double — число с плавающей точкой, хранимое с двойной точностью.
*	string — строка текста в свободной форме.
*	url — ссылка на ресурсы.
*	list — список QML-объектов.
*	enumeration — именованное перечисление.
*	var — общий тип.

Базовый тип — это тип, который ссылается на простое значение, например int или строку.
Это контрастирует с типами объектов QML, которые относятся к объекту со свойствами, сигналами, методами и т. д.
В отличие от типа объекта, базовый тип нельзя использовать для объявления объектов QML

## Базовые типы QtQuick

Базовые типы данных, определённые в QtQuick.

*	date — дата.
*	point — точка с координатами x и y.
*	rect — прямоугольник с x, y, width и height.
*	size — размер с атрибутами width и height.
*	color — цвет в формате ARGB.
*	font — шрифт со свойствами QFont.
*	matrix4x4 — матрица с 4 строками и 4 столбцами.
*	quaternion — кватернион с scalar, x, y и z.
*	vector2d — вектор с атрибутами x и y.
*	vector3d — вектор с атрибутами x, y и z.
*	vector4d — вектор с атрибутами x, y, z и w.

## Основные визуальные типы

Item — самый примитивный визуальный элемент в QML.
Часто используется в качестве контейнера для других элементов.
Все визуальные компоненты в QtQuick унаследованы от Item. 
