# Абсолютное и относительное позиционирование

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Способы позиционирования элементов

Одной из основных задач построения пользовательского интерфейса является размещение визуальных
элементов на экране.
Для решения этой задачи существует несколько способов:

*	с помощью абсолютных координат — абсолютное позиционирование;
*	с помощью якорей — относительное позиционирование;
*	с помощью контейнеров.

## Позиционирование вручную

Абсолютное позиционирование подразумевает использование свойств x и y, для указания местоположения
объектов на экране. 
Система координат имеет вид, представленный на слайде.
Точка начала координат (0, 0) находится в левом верхнем углу экрана.
Ось X имеет привычный вид и направлена вправо, а вот ось Y направлена вниз, а не вверх, как это принято
в математике.
При разработке приложений такой способ размещения редко используется.
Причина в том, что на разных устройствах одно и тоже (с точки зрения кода) расположение объектов
может отличаться за счет разного разрешения и соотношения сторон экрана. 

## Пример размещения вручную

На слайде приведён пример абсолютного позиционирования элементов.
Все параметры прямоугольников заданы вручную.

## Использование якорей

Относительное позиционирование объектов подразумевает использование якорей (свойств группы anchors). 
В разработке приложений чаще применяется этот способ позиционирования. 
Он позволяет настроить расположение объектов относительно других объектов, что не зависит
от разрешения и соотношения сторон экранов устройств. 

Anchors — группа свойств для размещения объекта относительно других объектов на экране.
Якоря бывают двух видов:

*	ссылающиеся на элемент: fill, centerIn;
*	ссылающиеся на другой якорь: top, bottom, left, right, anchors.verticalCenter и anchrors.horizontalCenter.

*	Якоря top, bottom, left и right позволяют связать каждую из границ объекта с якорем другого объекта.
*	anchors.centerIn позволяет разместить объект в центре другого объекта.
*	anchors.fill позволяет заполнить другой объект текущим.
*	anchors.verticalCenter и anchrors.horizontalCenter позволяют связать центр вертикали
	или горизонтали объекта с якорем другого объекта.
*	Свойства margins позволяют задать размер границ вокруг объекта.

## Пример использования якорей

На слайде приведён пример позиционирования элементов относительно друг друга.
