# Push-уведомления

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Push-сообщения

Сервис уведомлений предназначен для оперативной доставки информации
в виде текстовых Push-сообщений на мобильные устройства.

Если Push-сообщение отправлено, а мобильное устройство в данный момент недоступно,
мобильное приложение получит Push-сообщения после подключения к сети,
обеспечивающей доступ к Push-серверу.

Для использования Push-сообщений в своих системах разработчикам необходимо расширить
функциональность мобильного приложения и сервера, отправляющего Push-сообщения.

Протокол общения устройств с сервером Push-сообщений
не подразумевает передачу конфиденциальной информации.
Поэтому не рекомендуется передавать с помощью уведомлений
конфиденциальную и чувствительную информацию в незащищённых сетях.

При разработке приложения функциональность Push-сообщений можно тестировать двумя способами:

*	подключившись к тестовому серверу;
*	при помощи плагина для эмуляции Push-сервера.

## Работа с сервером Push-сообщений

Для того, чтобы протестировать автоматизированную систему (серверное приложение),
которая отправляет push-сообщения, и приложение-клиент, которое эти сообщения обрабатывает,
необходимо работать с тестовым сервером.

Чтобы использовать тестовый сервер в разработке, необходимо выполнить следующие шаги:

1.	Получить доступ к тестовому серверу:
	1.	обратиться с запросом на dev-support@omp.ru;
	2.	получить ключи для доступа;
	3.	использовать ключи в приложении-клиенте и автоматизированной системе.
2.	Создать и установить приложение-клиент на устройство:
	1.	установить зависимости;
	2.	передать в приложение `applicationId`, полученный от поддержки ОМП;
	3.	зарегистрироваться в push-демоне с помощью `applicationId`,
	получив в ответ `registrationId` для тестового сервера.
3.	Организовать передачу Push-сообщений от автоматизированной системы через тестовый сервер.
	1.	Передать `registrationId` автоматизированной системе
	доверенным способом от приложения-клиента.
	Это позволит автоматизированной системе отправлять таргетированные push-сообщения
	к своим мобильным приложениям на конкретном устройстве.
	2.	Получить токен доступа на тестовом сервере через автоматизированную систему.
	3.	Передавать через автоматизированную систему push-сообщения,
	используя токен доступа и идентификатор приложения `registrationId`.

Процесс регистрации мобильного приложения изображён на схеме на слайде.

Запрос на регистрацию мобильного приложения должен происходить при каждом его запуске.

## Настройки приложения и сервера

Настройки серверного приложения выдаются одни на компанию,
мобильных приложений и их настроек может быть несколько.

Настройки необходимо указать в конфигурации автоматизированной системы,
которая будет проходить аутентификацию и получать токен доступа на тестовом сервере,
а затем отправлять push-сообщения через тестовый сервер.

Список настроек серверного приложения/автоматизированной системы:

`project_id`
: Уникальный идентификатор проекта.

`push_public_address`
: Адрес тестового сервера, на который будут отправляться запросы.

`api_url`
: Адрес API тестового сервера.

`client_id`
: Аккаунт учётной записи клиента в подсистеме безопасности,
в большинстве случаев совпадает с ID проекта.

`scopes`
: Настройки области видимости (для OAuth 2).

`audience`
: Настройки аудитории для токена доступа (для OAuth 2).

`token_url`
: Адрес API тестового сервера, используемого для авторизации через токен.

`key_id`
: Идентификатор приватного ключа RSA для передачи сообщений между сервером приложений
и тестовым сервером.

`private_key`
: Приватный ключ RSA для передачи сообщений между сервером приложений и тестовым сервером.

Настройки мобильных приложений:

`application_id`
: Уникальный идентификатор приложения-клиента;

`project_id`
: Уникальный идентификатор проекта.

`application_id` необходимо использовать для регистрации в push-демоне на мобильном устройстве.
Каждому `application_id` может соответствовать только одно приложение.

## Настройка push-демона

После установки push-демона необходимо его настроить,
чтобы он связывался с нужным сервером.

Для указания адреса и порта сервера, который будет использован push-демоном для соединения,
необходимо выполнить команду от суперпользователя.

В полях `address` и `port` нужно указать адрес и порт push-сервера.
В поле `address` нужно указывать URL без протокола.

После обновления конфигурации необходимо перезагрузить push-демон.

После перезапуска push-демона можно проверить текущие настройки push-демона.

Они будут содержать указанные ранее адрес, порт, а также статус валидации соединения с сервером.
True означает, что демон будет учитывать ssl-ошибки.

## Настройки конфигурации

Для приложения нужно в файле .desktop указать возможность принимать uri в качестве аргумента:

Для доступа к push-демону необходимо разрешение PushNotifications, которое можно задать в поле Permissions секции [X-Application].
Также может потребоваться разрешение Internet для доступа к глобальной сети.

Имеется ограничение на имена D-Bus шин, которые может поднимать приложение.
Доступны только имена вида orgname.appname, где orgname и appname задаются в секции [X-Application] файла .desktop.

В pro-файле необходимо указать, что приложение использует Qt D-Bus и дополнительные библиотеки pushclient и nemonotifications-qt5.

## Альтернативная библиотека pushapi

При использовании библиотеки pushclient графические уведомления нужно создавать самостоятельно, например, при помощи nemonotifications-qt5.

В ОС версии 5.0 реализован новый механизм доставки push-уведомлений напрямую в UI. Данный механизм убирает необходимость создавать уведомления непосредственно из приложения. Переход на новый механизм требует только подключения новой библиотеки libpushapi.

Приложение может реализовать в своём D-Bus-сервисе метод, который будет вызван при клике на push-уведомление, если его имя было передано в поле action push-уведомления. На текущий момент поддерживается только один метод на push-уведомление и не поддерживаются методы с аргументами.

Сервис приложения будет автоматически определён как конкатенация полей OrganisationName и ApplicationName из секции X-Application файла .desktop. Для того, чтобы метод выполнялся в том числе при выключенном приложении, необходимо сделать приложение активируемым через D-Bus путём добавления поля ExecDBus в секцию X-Application:

Библиотеки libpushclient и libpushapi конфликуют друг с другом, поэтому одновременно можно использовать только одну из них.

## PushNotifications — API для работы с Push-сообщениями

Для разработки приложения клиента нужно использовать библиотеку libpushclient.
В ней имеется пространство имён PushNotifications.
Это пространство имён предоставляет API для работы с системой push-уведомлений.

Классы

Client - клиент для системы push-уведомлений.
Push - структура push-уведомления.
PushList - синоним для QList<Aurora::PushNotifications::Push>

## Приложение-клиент

В начале работы приложения необходимо выполнить следующие действия:

1.	Установить `applicationId` с помощью метода `Aurora::PushNotifications::Client::setApplicationId()`.
2.	Вызвать метод `Aurora::PushNotifications::Client::startHandler()`.

Этот идентификатор можно вынести в конфигурацию мобильного приложения
или программно запрашивать у своей автоматизированной системы до начала процесса регистрации.

Каждому `applicationId` может соответствовать только одно приложение.

На основе `applicationId` push-демон определяет соответствующий ему `deviceID`.
После этого при вызове метода `registrate()` эта пара отправляется на сервер.
На сервере производится проверка, существует ли такая пара.
Если нет, то генерируется `registrationId`, который возвращается приложению через push-демон.
Если же пара уже была зарегистрирована, то возвращается уже существующий `registrationId`.
Поэтому `registrationId` является постоянным для связки приложения и устройства.

Если пользователь не был активен в течение длительного времени,
то будет отправлен сигнал `clientInactive`.
При этом, если приложение работает в фоновом режиме и не выполняется никаких активных процессов,
то оно должно завершить работу, чтобы экономить заряд аккумулятора батареи.
В дальнейшем, чтобы возобновить работу приложения, его будет необходимо запустить заново.

## Собственный сервер

После того, как мобильное приложение на устройстве сможет зарегистрироваться в push-демоне,
оно сможет отправить уникальный `registrationId` своей автоматизированной системе.

Для этого в автоматизированной системе необходим процесс,
который способен получать и сохранять `registrationId`,
чтобы в дальнейшем была возможна таргетированная отправка push-сообщений.

Push-сообщения отправляются через API сервера push-сообщений,
который защищён протоколом
OAUTH2 OpenID Connect согласно JSON Web Token (JWT) Profile для OAuth 2.0 Client Authentication.
При этом используется метод аутентификации
`private_key_jwt`.

Этапы отправки push-cообщений:

1.	Получение токена, позволяющего в течение времени его жизни отправлять push-сообщения.
2.	Непосредственно отправка push-сообщения.

Для получения токена необходимо на основании адреса для запроса токена Рush-сервера `token_url`
из настроек сделать неавторизованный запрос.

В параметрах запроса необходимо указать данные:

*	тип авторизации "client_credentials";
*	`audience` из файла настроек сервера;
*	`scope` из файла настроек сервера;
*	`client_assertion_type` как строку "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
*	`client_assertion` как сформированный самостоятельно токен jwt.

Из ответа следует считать атрибуты `access_token` и `expires_in`,
которые возвращают токен и время его действия.

## Отправка push-сообщений

Для отправки push-сообщения необходимо сформировать запрос на сервер,
указанный в `api_url`.
К адресу сервера необходимо добавить фрагмент `projects/<project_id>/messages`,
содержащий идентификатор проекта из настроек.

Заголовок `Accept` должен иметь значение `application/json`.

Обязательные параметры тела запроса:

`target` - `registrationId`, полученный из приложения после его регистрации на push-сервере
`type` - поддерживается значение `device`
`ttl` - время жизни push-уведомления. Можно задавать только в следующих единицах: `s` — секунды, `h` — часы, `m` — минуты.
`notification` - содержание push-уведомления

## Структура push-сообщения

Каждое push-сообщение содержит поля для заголовка, тело сообщения и объект с данными,
который представляет собой набор пар ключ-значение.
Мобильному приложению доступны только три атрибута:

*	`title`;
*	`message`;
*	`data`.

Следует обратить внимание, что `data` является сериализованным в строку JSON-объектом.
Формат JSON-объекта в `data` может быть произвольным.
Атрибут `data`, в частности, можно использовать для указания типа push-сообщения — `text`,
`command` и т.&#8201;д., например `"{"type": "command", "text": "value"}"`.

Список этих структур `Aurora::PushNotifications::PushList`
возвращается с сигналом `Aurora::PushNotifications::Client::notifications`.
Каждое push-собщение, полученное таким образом,
в дальнейшем может быть выведено как уведомление.

## Push-плагин в Аврора IDE

В Аврора SDK на эмуляторе можно тестировать работу приложения-клиента с push-сообщениями.

Для настройки плагина Push-уведомлений необходимо выполнить следующие действия:

1.	Сгенерировать сертификат **cert.pem** и ключ **key.pem**.
	Для этого необходимо выполнить команду `openssl` в терминале в системе разработчика.
	Поля в опции `-subj` можно заполнить собственными значениями вместо многоточий или опустить.
	Ограничений на данные значения нет.
2.	В Аврора IDE запустить машину сборки Build Engine — нажать кнопку запуска,
	расположенную в нижнем левом углу IDE.
3.	Создать файл настроек для службы push-уведомлений:
	**«Параметры» -> «Push-уведомления» -> вкладка «Push-сервер» -> «Создать»**.
4.	На той же вкладке **«Push-сервер»** в разделе **«Настройки»** указать ключи из шага 1 в полях
	**«Файл сертификата»** и **«Файл ключа»**.
5.	При необходимости можно добавить значение по умолчанию для полей **«Данные»**
	и **«Заголовок»** на вкладке **«Значения по умолчанию для уведомлений»**.
6.	Нажать кнопку **«Применить»**.
	Плагин должен внести устройство в список и выдать ему уникальный идентификатор.
7.	Открыть приложение-клиент push-сообщений на эмуляторе.
8.	В Аврора IDE открыть нижнюю вкладку **«Push-уведомления»**
	или нажать сочетание клавиш `Alt`+`9`.
	На вкладке должно появиться сообщение о регистрации приложения-клиента,
	содержащее его `applicationId`.
9.	Выбрать идентификатор устройства.
10.	Ввести идентификатор приложения `applicationId` в поле справа от идентификатора устройства.
11.	Ввести текст уведомления и нажать кнопку **«Отправить push-уведомление»**.

## Фоновые задачи

В Аврора 5.2+ механизм работы с уведомлениями может быть реализован через фоновые задачи.

Каждое приложение знает свой backroundTaskID и никуда его не передаёт. onTaskStarted выполняется только если backroundTaskID будет совпадать со значением, зарегистрированным в desktop-файле приложения ([X-Task PushWorker]). Для данного случая это PushWorker. backroundTaskID задаётся в desktop-файле как [X-Task backgroundTaskId].

На слайде приведён пример, как приложение запускается как фоновая задача.
