# Структура проекта

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Начало работы с проектом

Создание или открытие проекта приложения.

*	Файлы проекта должны быть в директории, указанной при установке SDK, или в домашнем каталоге.
*	Приложение из базового шаблона.
*	Начало → Проекты → Новый проект.
*	Открытие существующего проекта Меню → Файл → Открыть файл или проект.

## Создание приложения

Для создания нового проекта из шаблона необходимо выполнить следующие действия:

1.	В основном окне Аврора IDE выбрать пункт меню «Файл» → «Создать файл или проект...».
2.	В открывшемся окне «Новый файл или проект» выбрать вкладку «Проекты» → «Приложение»
	и отметить «Приложение Qt Quick для ОС Аврора», после чего нажать кнопку «Выбрать...».
3.	В появившемся окне «Введение и размещение проекта» указать название вашей организации,
	имя проекта, директорию.
	Важно иметь в виду, что проект должен находиться или в домашней директории пользователя,
	или в альтернативной директории, указанной при установке Аврора SDK.
	Если отметить пункт «Размещение проекта по умолчанию», то указанная директория будет
	предлагаться для следующих создаваемых проектов.
4.	На следующих двух вкладках необходимо указать разрешения, которые необходимы вашему приложению.
	Это может быть доступ к директориям, к api для работы с данными и т.п.
5.	В качестве системы сборки можно выбрать CMake.
6.	В открывшемся окне «Выбор комплекта» выбрать необходимые комплекты для сборки и нажать кнопку «Далее».
	Комплекты armv7hl и aarch64 используются для мобильных устройств, x86_64 — для эмулятора.
	Позже набор комплектов можно изменить в настройках проекта.
7.	В следующем окне «Application Details» ввести необходимые данные о приложении и нажать кнопку «Далее».
8.	В появившемся окне «Управление проектом» выбрать необходимые данные и нажать кнопку «Завершить».
	Данное окно позволяет настроить взаимное положение проекта относительно других и подключить одну
	из систем контроля версий, доступных в операционной системе.
9.	В открывшемся редакторе исходного кода можно приступить к работе над проектом.

## Директория проекта приложений

Структура проекта:

*	Сборка с cmake
	*	CMakeLists.txt — описание структуры, модули
*	Сборка с qmake
	*	Файл .pro содержит описание структуры, подключаемые модули и другие конфигурационные настройки проекта.
	*	Файл .pro.user — файл с локальными настройками. При распространении проекта его передавать не надо.
*	В каталоге src файлы с расширением .cpp содержит исходный код на C++, файлы
	.h — это заголовочные файлы на C++.
*	Файлы .qml в каталоге qml содержат исходный код на QML.
*	icons — иконки для значка приложения
*	rpm/<имя проекта>.spec — параметры сборки rpm-пакета
*	<имя проекта>.desktop — параметры запуска приложения
*	Файлы .ts в каталоге translations — это файлы переводов.

## Файл .desktop

В desktop-файле следует придерживаться следующей структуры.

Использование значения строки X-Nemo-Application-Type=silica-qt5 позволяет проверить,
что приложение использует модуль Silica, который позволяет ускорить запуск приложения.

В строке Icon следует указывать название пакета (оно же имя графического файла для значка).
В строке не требуется указывать абсолютный путь к файлу.

Строка Exec должна содержать команду для запуска.

Значение строки `Name` определяет название приложения на экране приложений ОС Аврора.
Значение не обязательно должно совпадать с названием пакета в установочном пакете и быть уникальным.
Таким образом, на экране приложений ОС Аврора может быть более одного приложения c одним названием.

Для локализации названия приложения используется конструкция Name[<двухбуквенный_код_языка>].
Например, Name[ru] позволяет задать название приложения для русскоязычного интерфейса.

## Управление правами приложения

Начиная с версии 4.0.1 в Аврора OS реализован механизм безопасного исполнения приложений
в песочнице (т.н. Изоляция).
Изоляция в Аврора OS основана на системе Firejail, которая, в свою очередь, основана на SUID,
Linux Namespaces и seccomp-bpf.
Система ограничений прав приложений применима только к приложениям, запускаемым в песочнице. 
В дальнейшем изоляция будет применяться ко всем запускаемым приложениям.
Права ("разрешения") необходимые для работы приложения указываются в видоизмененном .desktop-файле,
формат которого указан ниже.
Там же, в явном виде, указывается запуск приложения в секции X-Application.

Для запуска в песочнице Аврора OS приложение должно соответствовать определённым правилам,
которые сейчас будут разобраны.

## Секция X-Application

Рассмотрим требования к формату секции `[X-Application]` desktop-файла на примере.

| Параметр           | Описание                                                                       |
|--------------------|--------------------------------------------------------------------------------|
| `Permissions`      | Список идентификаторов требуемых прав со знаком "**;**" в качестве разделителя |
| `OrganizationName` | Название организации-разработчика                                              |
| `ApplicationName`  | Имя директории, выделенной для хранения данных приложения                      |

Разрешения предоставляют доступ к директориям, содержащим данные определённого типа,
интерфейсам D-Bus, определённым типам сокетов и приложений.
В настоящее время приложения должны определять все необходимые разрешения в desktop-файле,
и все они предоставляются в момент запуска.

## Доступные директории

Используйте правильные каталоги данных приложения

OrganizationName и ApplicationName используются для предоставления приложению прав
на запись в директории.

1.	$HOME/.local/share/\<Название организации\>/\<Имя приложения\>
2.	$HOME/.cache/\<Название организации\>/\<Имя приложения\>

Для доступа к указанным выше каталогам из приложения используйте `Aurora::Application::Paths` из Libauroraapp.

1.	Данные приложения — Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::AppDataLocation)
2.	Кеш приложения — Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::CacheLocation)

Только эти каталоги могут использоваться для хранения данных приложения.

## Основной объект приложения Qt

Измените основной объект приложения Qt, установив организацию и имя приложения,
чтобы соответствовать объявлению, добавленному в файл рабочего стола.

## Разрешения для приложений [1]

Разрешения, необходимые для использования функциональности.

Функции мобильного устройства:

*	Технология Bluetooth: Bluetooth — Подключение и использование оборудования Bluetooth и NFC
*	Получение координат: Location — Использование GPS и определение местоположения
*	Технология NFC: NFC

Сеть:

*	Управление сетевыми подключениями: Internet — Передача данных и подключение к Интернету
*	Отображение WEB-контента: WebView
*	Передача данных: Internet

Мультимедиа:

*	Проигрывание и запись аудио и видео: Audio, Microphone.
*	Низкоуровневые функции работы аудио: Audio, Microphone.
*	Camera — Съемка фотографий и видео.
*	Audio — Воспроизведение звука, изменение конфигурации звука и отображение элементов
	управления звуком на экране блокировки.

## Разрешения для приложений [2]

Доступ к системным службам:

*	MediaIndexing — Получение списка файлов на устройстве.
	Если у вас есть доступ к каталогу данных, вы можете также использовать его.
*	SecureStorage — Безопасное хранение данных.

Помимо них, для профилей Extended, Antivirus и MDM также возможно использование разрешения
LogSecurityEvents (для записи в sdjd).

При запросе резрешений учитывается профиль безопасности, выбираемый автоматически в соответствии с сертификатом разработчика. Для каждого профиля предусмотрены дополнительные API, доступ к которым можно получить только с помощью этого профиля. Существует несколько профилей безопасности:

Regular - Базовый профиль для разработки стандартных приложений.
Antivirus - Профиль, наследуемый от Regular, с дополнительными компонентами для разработки антивирусного программного обеспечения.
Extended - Профиль, наследуемый от Regular, с дополнительными компонентами для разработки vpn-клиентов.
Market - Профиль, наследуемый от Regular, с дополнительными компонентами для разработки магазина приложенй.
MDM - Профиль, наследуемый от Extended, с дополнительными компонентами для работы с mdm.

## Разрешения для приложений [3]

Для доступа к дополнительным директориям, которые могут быть доступны нескольким приложениям,
необходимо использовать следующие разрешения:

*	RemovableMedia
*	UserDirs
*	Documents — Доступ к директории документов
*	Downloads — Доступ к директории загрузок
*	Music — Доступ к директории Music, плейлистам и изображениям обложек
*	Pictures — Доступ к директории изображений и эскизам
*	PublicDir — Доступ к директории ~/Public
*	Videos — Доступ к директории видео и эскизам

UserDirs даёт доступ ко всем директориям, которые предоставляются при использовании следующих разрешений:
Documents, Downloads, Music, Pictures, PublicDir, Videos.
