# Этапы запуска проекта

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Сборка проекта

Доступны наборы для сборки под определённую архитектуру.
Для эмулятора возможно использовать только i486.
Типы сборки. Debug — для разработки, присутствет отладочный вывод и возможность
использовать отладчик.
Release — тип для сборки приложения, поставляющегося конечному пользователю.

## Запуск приложения

Перед установкой нужно указать, на какое устройство или эмулятор нужно устанавливать
собранный rpm-пакет.
Также на вкладке "Проекты" в разделе "Запуск" нужно настроить этап подписи:
указать ключ и сертификат.

Способы установки на устройство. Установить как RPM пакет — собирается RPM пакет,
содержащий скомпилированный исходный код и ресурсы, и устанавливается на устройство
с использованием RPM установщика.
Установить копированием — скомпилированный исходный код и ресурсы копируются на устройство.
Последний — самый быстрый метод.

После того, как выбраны все опции, можно запускать сборку.

## Установочные пакеты

ПО для ОС Аврора распространяется в виде rpm-файлов.

RPM-файл содержит:

*	Исполнительный файл приложения
*	Иконки и desktop-файлы
*	Подключаемые библиотеки
*	Ресурсы
*	Зависимости
*	Скрипты установки и удаления
*	Подписи

## Сборка и запуск проекта

В pro-файле и spec-файле хранятся настройка конфигурации приложения.

Основные этапы сборки и запуска проекта:

1.	Сборка rpm на основе spec-файла.
2.	Подпись rpm-пакета.
3.	Валидация rpm-пакета.
	В том числе валидируется подпись.
4.	Установка rpm-пакета на устройство или эмулятор.

## Подписание установочных пакетов

Установочные пакеты приложений для ОС Аврора должны быть подписаны электронными подписями,
позволяющими идентифицировать разработчиков и избежать попадания на мобильные устройства
нежелательных приложений.

Для подписания пакета необходимы:

*	Закрытый ключ подписывающей стороны (`key.pem`).
*	Сертификат подписывающей стороны (`cert.pem`).

Подпись разработчика - обязательная подпись, без этой подписи установка приложения на устройство с ОС Аврора невозможна. Имеет подтипы в соответствии с профилем безопасности.
Публичная используется разработчиком приложения для разработки и отладки приложения.
Персональная (на имя компании) используется вендором приложения для выпуска релиза.

Подпись источника используется для подтверждения, что пакет получен из доверенного источника (компании-клиента или магазина приложений).

## Выпуск сертификата

Разработчики не могут использовать самостоятельно созданные сертификаты для подписания пакетов.
Чтобы получить сертификат, разработчик должен сначала сгенерировать CSR
(запрос на сертификат для подписания пакетов).
Генерация сертификата осуществляется с помощью утилиты OpenSSL.

Полученный файл запроса (но не файлы ключей) необходимо передать полномочному представителю
компании ООО «Открытая мобильная платформа», отправив письмом на dev-support@omp.ru.

Сгенерированный файл `cert.pem` будет отправлен разработчику.

## Публичные ключевые пары

Публичные ключевые пары созданы для того, чтобы разработчики партнёров
могли их использовать для разработки и отладки.
Эти ключи не смогут работать в реальных устройствах, находящихся в эксплуатации,
т.к. они будут добавлены в чёрные списки.
Начиная с Аврора 5, общедоступные ключи блокируются до включения режима разработчика, и без включения режима разработчика пользователем установка и запуск приложений, подписанных такими ключами, блокируется.
Публичные ключевые пары поставляются вместе с Аврора SDK.

Передаваемые партнёрам персональные ключи являются приватными и использовать их должны только
сотрудники, уполномоченные подписывать релизы приложений.

## Подпись приложений в IDE

Функция подписания приложения перед его установкой на устройство управляется
из Aurora IDE, для этого необходимо:

1.	Переключиться в режим «Проекты» и открыть настройки запуска необходимого комплекта для сборки.
2.	Выбрать метод запуска. Подписание пакетов приложения доступно только для следующих методов:

	*	Build RPM Package For Manual Deployment;
	*	Deploy As RPM Package.

3.	Включить подписание RPM-пакета нажатием кнопки "Включить"
4.	Раскрыть вкладку «RPM Sign» нажатием кнопки `Подробнее` и указать:

	*	путь и имя файла ключа;
	*	путь и имя файла сертификата.

## Программа-валидатор rpm-файлов

Валидатор проверяет установочные RPM-пакеты для ОС Аврора на соответствие требованиям.

Валидатор RPM-пакетов можно запустить в:

*	среде сборки
*	Aurora IDE

Валидатор также всегда вызывается во время установки пакетов
в ОС Аврора.

Указанный профиль безопасности должен соответствовать сертификату разработчика приложения.
Используемый профиль ограничивает список разрешенных зависимостей (библиотек, модулей Qt и QML),
допустимых путей для размещения файлов.
Предусмотрено 4 профиля безопасности, **Regular**, **Extended**, **MDM**	и **Antivirus**.
Extended, MDM и Antivirus являются расширениями Regular, для них предусмотрен расширенный
список разрешенных зависимостей.

На период разработки приложения и различных экспериментов валидатор может быть отключён вручную.
Это может быть полезно при исследованиях библиотек, которые могут понадоббиться приложению для работы.
Но для промышленной эксплуатации (когда разработчик заканчивает работу и передает приложение в заказчику)
приложение должно проходить валидацию успешно, иначе им нельзя будет пользоваться официально (публично).

## Валидатор в Аврора IDE

Валидатор RPM-пакетов также можно запускать после сборки и подписи пакета в Aurora IDE
для сертифицированной версии ОС:

1.	Переключиться в режим «Проекты» и открыть настройки запуска необходимого комплекта для сборки.
2.	Выбрать метод запуска.
3.	Удостовериться, что в этапах запуска есть «**RPM Validation**: Проверки RPM пакета».
	В противном случае добавить добавить этап в выпадающем меню «Установка, добавить этап» ниже
4.	Выбрать нужный профиль валидации в выпадающем списке «Profiles».
5.	В случае необходимости добавить ключи в поле «Аргументы».
6.	Запустить сборку и установку приложения.
	В консоли сборки будет отображён отладочный лог валидатора и результат.

## Проверяемые требования

Скрипт вполняет проверку пакета приложения на соответствие базовым требованиям:

*	Проверка имен пакетов
*	Проверка имени файла, пути и разрешений
*	Размер и формат иконок
*	Импорт QML, разделяемые библиотеки и зависимости RPM
*	Очень простой статический анализ возможных проблем с кодом

Успешная проверка означает, что пакет в порядке, однако она не гарантирует,
что пакет или приложение будут установлены.

Однако отказ в проверке означает, что пакет НЕ будет установлен, поэтому необходимо
исправить все ошибки проверки.

## Общие требования к rpm-пакетам

Общие требования

*	Файлы установочного пакета должны быть размещены в определённых директориях.
	В том числе при установке приложения файлы не должны создаваться в домашней
	директории пользователя.
*	Файлы не должны содержать абсолютные пути импорта модулей QML.
*	Установочный пакет не должен содержать файлы систем управления версиями.
*	Файлы и директории в установочном пакете должны оставаться под контролем менеджера пакетов RPM,
	им нельзя присвоить права доступа chmod 666 или chmod 777.
	Изменение или удаление файлов извне не имеет смысла,
	данные восстановятся после обновления или переустановки пакета.
*	В исполняемых файлах запрещено использовать флаги доступа
	**Set User/Group ID Upon Execution (suid/sgid)**,
	поскольку не допускается запуск приложения от пользователя root.
*	Размер файла установочного пакета не должен превышать 200 мегабайт.
	Это требование Аврора центр.
	Приложения с оффлайн картами вполне могут превышать этот размер.

## Установочный пакет и пути

Установочный пакет следует именовать следующим образом — 
<название_пакета>-<версия>-<релиз>.<архитектура>.rpm, где:

*	<название_пакета> — имя пакета,
	которое является основным именем для остальных файлов в установочном пакете.
*	<версия> указывается в .spec/.yaml файле для сборки приложения в строке Version.
*	<релиз> указывается в .spec/.yaml файле для сборки приложения в строке Release.
*	<архитектура> может быть armv7hl или i486.

Пути к файлам

Файлы должны быть размещены в следующих директориях RPM-пакета:

*	/usr/bin/<название_пакета> — исполняемый файл;
*	/usr/share/applications/<название_пакета>.desktop — файл в формате .desktop;
*	/usr/share/icons/hicolor/<размер>/apps/<название_пакета>.png — файлы значка приложения;
*	/usr/share/<название_пакета>/*	— прочие файлы
	(данные приложения, собственные разделяемые библиотеки, импорт собственных QML-файлов и т.д.).

## Имя приложения

*	В именах приложения и проекта не допускаются тире.
*	Рекомендуется для имён использовать нотацию CamelCase.
*	Имя приложения должно иметь формат <OrganizationName>.<ApplicationName>.

## Файл .spec

Версия установочного пакета указывается в строке Version в spec-файле.
Для указания версии следует придерживаться принципов семантического версионирования в формате
**X.Y** или **X.Y.Z**.

**Примечание**	— версия приложения для Аврора Маркет может состоять только из цифр,
разделенных точками.
Длина строки версии — от 1 до 20 символов.
Во время загрузки приложения в Аврора Маркет
версия нового релиза должна быть выше ранее загруженного релиза.
Увеличить номер версии можно с сохранением предыдущего формата релиза
или с добавлением минорной версии.

Релиз установочного пакета указывается в строке Release в .spec-файле.
В строке релиза допускается использовать только числа, символ точки и подчеркивания.

Зависимости для приложения указываются в строке Requires в .spec-файле.

## Данные, конфигурация и кэш

Файлы с данными можно устанавливать в /usr/share/<название_пакета>.
Если пользователю требуется отключить системные данные, то можно использовать флаг
в $XDG_*_HOME/<название_пакета>.
Отключение системных данных не освободит место, но в случае сокрытия или ошибки
при загрузке данных уменьшится время запуска и отзывчивость приложений.

Большой объем данных не рекомендуется размещать в RPM-пакете для установки
в /usr/share/<название_пакета> из-за ограниченных ресурсов целевых устройств.
RPM-пакет будет конкурировать за свободное дисковое пространство с другими приложениями
и может потерять возможность установиться или обновиться из-за нехватки свободного места.

В установочном пакете рекомендуется размещать только скомпилированный код приложения,
QML-файлы интерфейса пользовтеля, файлы значков, файлы переводов и сопутствующие системные файлы.

## Модули QML

Поставляемые в пакете модули QML рекомендуется называть с префиксом, соответствующим названию
пакета — например, MyAppName или MyAppName.ModuleName.

Собственные и сторонние модули QML, поставляемые в установочном пакете, следует размещать
в директории /usr/share/<название_пакета>/qml.

## Значок приложения

Изображения значка приложения должны быть в формате .png и называться в соответствии
с установочным пакетом (строка Icon в .desktop-файле).

С приложением должны поставляться изображения значка следующих размеров:

*	86 × 86;
*	108 × 108;
*	128 × 128;
*	172 × 172.

Изображения именно этих размеров требуются для отображения на различных устройствах
с разными размерами и разрешениями экрана.
Другие размеры не поддерживаются.

Рекомендуемая структура размещения файлов значка имеет следующий вид.

## Разделяемые библиотеки

Разрешенные для использования в приложении разделяемые библиотеки приведены в разделе
Допустимые зависимости приложений ОС Аврора.
Следует обратить внимание на библиотеки с пометкой **(deprecated)**, в текущих версиях ОС Аврора
их использование допускается, но соответствующие компоненты более не развиваются и станут
недоступными в одной из ближайших версий ОС.

Собственные и сторонние разделяемые библиотеки, поставляемые в установочном пакете,
следует размещать в директории /usr/share/<название_пакета>/lib.

## Использование модулей Qt

Модуль QtWidgets запрещен для использования, так как не оптимизирован для интерфейса пользователя
ОС Аврора (выполнение программного кода будет намного медленнее, чем рендеринг с использованием
Qt Quick и OpenGL ES).

Альтернатива использованию модуля QtOpenGL.

Модуль QtOpenGL также запрещен для использования (из-за обширных зависимостей от модуля QtWidgets),
вместо него рекомендуется использовать ряд классов допустимого модуля Qt GUI.
В большинстве случаев использование Qt GUI означает переименование классов
из QGL*	→ QOpenGL*	и удаление ссылки на QtOpenGL.
В некоторых случаях требуются изменения API, но они не должны быть слишком сложными.

D-Bus API доступны для использования, если к ним есть права доступа из приложения
без необходимости повышения привилегий.

Запрещено поставлять в RPM-пакете файлы в формате .service, активирующие шину D-Bus.
