# ОС Аврора

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Операционная система Аврора

ОС Аврора — это операционная система, предназначенная для смартфонов и планшетов, она основана
на Linux, это POSIX-овместимая ОС.

Операционная система была разработана таким образом, чтобы предоставлять удобную многозадачность.
Это реализовано с помощью интерфейса пользователя который ориентирован под управление жестами,
сейчас эту тенденцию перенимают также Android и iOS.

Аврора гарантирует надежную защиту конфиденциальной информации как
в индивидуальном, так и корпоративном использовании.
Встроенная система защиты информации шифрует данные, которые отправляет и принимает пользователь.

Смартфоны и планшеты на ОС Аврора управляются через единый центр.
С его помощью можно настраивать корпоративные политики управления
(например, удалённая установка приложений, их обновление, трекинг перемещений мобильного устройства и т.д.).

## UI/UX ОС Аврора

Особенности пользовательского интерфейса ОС Аврора.

*	Управление жестами - приложения управляются с помощью набора жестов.
*	Автоматическая адаптация под светлую/тёмную тему и другие, определеямые атмосферами.
	Цветовая схема определяется текущей атмосферой ОС Аврора.
	Для светлой схемы Light (DarkOnLight) будут определены тёмный цвет шрифта и значков и светлый фон,
	для тёмной схемы Dark (LightOnDark) — светлые цвета содержимого и тёмный фон.
*	Персонализация внешнего вида приложений.
*	Адаптивные приложения для смартфонов и планшетов.
*	Быстрые действия с экрана задач.
*	Высокая скорость работы интерфейса.
*	Функциональные системные уведомления.

## Особенности ОС Аврора

ОС Аврора обладает рядом особенностей.

В ее основе лежит полноценная Linux-система, и в режиме разработчика доступны все привычные утилиты.
Полная многозадачность по принципу десктопных систем позволяет пользователю запускать несколько
приложений и управлять ими в свернутом виде.

Для распространения приложений используется система пакетов rpm.
Пакеты подписываются и проверяются на соответствие требованиям ОС Аврора.

И с устройством, и с SDK можно взаимодействовать в режиме разработчика: через терминал,
в частности, с помощью ssh и другие команды bash.

Основные библиотеки для создания прикладного ПО представлены фреймворком Qt — удобным
как для создания интерфейсов, так и для доступа к различным API.
Графические интерфейсы приложений можно разрабатывать с помощью QML.

Приложения взаимодействуют между собой через интерфейсы D-Bus.

IDE для разработки основана на Qt Creator и во многом обладает его интерфейсом.

## Корпоративная мобильность

Одна из задач компании Открытая мобильная платформа состоит в том, чтобы предложить заказчикам
возможность создавать собственную инфраструктуру для управления парком мобильных устройств.

Важно уметь отслеживать статусы устройств, управлять набором доступных приложений
и обновлениями ОС, а также иметь возможность заблокировать устройство, например, в случае утери,
и безопасно удалить данные.

Это возможно благодаря сопутствующему продукту Аврора-центр — платформе управления мобильными
устройствами.
Она разворачивается на сервере и  предоставляет набор функций для управления устройствами, которыми
пользуются сотрудники, набором приложений и обновлениями ОС.

Система уведомлений Аврора предназначена для доставки push-сообщений на смартфоны и планшеты
под управлением мобильной ОС Аврора.
Для отправки безопасных push-сообщений на устройство организован push-сервер.

ОС Аврора внесена в реестр отечественного ПО, зарегистрирована в Роспатенте и обладет рядом
сертификатов ФСБ и ФСТЭК на соответствие требованиям профиля защиты операционных систем.
Также для защиты данных на ОС АВрора можно использовать сертифицированные VPN-каналы.

## Устройства на ОС Аврора

ОС Аврора устанавливается на смартфоны и планшеты.

Продажа мобильных устройств осуществляется только корпоративным (B2B) и государственным заказчикам (B2G).

Актуальный список устройств представлен на сайте auroraos.ru.

## Архитектура ОС Аврора

Архитектура операционной системы состоит из трех уровней.

На базовом уровне находятся ядро линукс, аппаратно зависимые компоненты и прошивка.
Уровень связующего ПО предназначен, как правило, для фреймворков.
В данном случае он включает в себя mer, который содержит цель для сборки кода и запуска ОС Аврора
и qml-приложений.
Цель (таргет) — это набор библиотек, заголовков для конкретной версии или архитектуры процессора.

Фреймворк Qt предоставляет основные библиотеки для разработки прикладного ПО.
Используется в качестве основной среды разработки приложений и предоставляет API для частого
использования других функций устройства.

Верхний уровень предназначен для приложений и графического интерфейса.

Основной домашний экран и область пользовательского интерфейса приложения управляются подсистемой
Lipstick, которая обрабатывает:

*	домашний экран и панель запуска приложений;
*	навигацию с помощью жестов в основном системном интерфейсе;
*	композицию приложений;
*	окна и уведомления на системном уровне и на уровне пользовательского пространства;
*	блокировку устройства;
*	и изменение внешнего вида интерфейса

ОС Аврора включает в себя большое количество связующих библиотек и фреймворков, многие из которых
используются приложениями.
Такие библиотеки и фреймворки написаны на языках C и C++.
Библиотеки, которые используются непосредственно в UI, включают в себя модули QML.
Это позволяет приложениям использовать их без дополнительных биндингов. 

Системные библиотеки включают в себя функции управления системой и устройством, в том числе:

*	обновление системы;
*	контроль устройств и обработка событий (например, событий, связанных с USB, зарядным
	устройством, разъемом для подключения наушников и тд);
*	управление режимом электропитания.

В ОС Аврора используется менеджер системы и сервисов systemd.
Данный подход сильно отличается от типичных скриптов инициализации SysV, но также является более
подходящим для мобильных систем в связи с запуском демонов по запросу.

Также используется дополнительный демон sensord, позволяющий записывать данные с датчиков
в циклические базы данных  для последующей визуализации.

Компоненты, организующие интерфейс пользователя находятся в составе бибилиотеки Silica.

## Аврора SDK

Аврора — единственная из российских ОС на настоящий момент, которая предоставляет полноценный собственный SDK.

Аврора SDK — это набор инструментов разработчика для создания прикладного ПО.
IDE основана на Qt Creator.
Среда сборки распространяется внутри Virtual Box, что позволяет использовать одни и те же утилиты
независимо от хостовой ОС.
Альтернативно вместо Virtual Box можно использовать Docker.
Эмулятор поставляется с образом ОС. 

В IDE для разработки можно подключить внешние устройства, чтобы проверять работу приложения
на реальном смартфоне или планшете.
Установочные пакеты в IDE можно и нужно подписывать и валидировать.
Эти действия можно задать на этапе сборки прложения, а также использовать для них плагины.

Кроме того, в IDE интегрированы документация и примеры.

## Безопасность ОС Аврора

Прикладная
Все механизмы сконфигурированы и работают изначально,
не требуют дорогостоящей настройки
Эшелонированная
Используется комплекс мер и методов,
которые пересекаются и дополняют друг друга.

ОС Аврора имеет эшелонированную целостную модель безопасности.
Изолирует каждое приложение и обеспечивает валидацию происхождения.

## Технологии разработки для ОС Аврора

*	Qt/C++ QML
	(Нативная разработка)
	*	Фреймворк для создания высокопроизводительных приложений с прямым доступом к API ОС Аврора
	*	Производительность
	*	Доступ ко всем API
	*	Нативный UI/UX
	*	Выбрать, если:
		*	Нужен полный контроль над приложением
		*	Важна максимальная оптимизация
*	Flutter/Dart
	(Кросс-платформа)
	*	UI-фреймворк для создания адаптивных приложений с единой кодовой базой для Аврора/Android/iOS
	*	Единый код
	*	Быстрая разработка UI
	*	Горячая перезагрузка
	*	Выбрать, если:
		*	Нужно покрыть несколько платформ
		*	Уже есть приложение на Flutter для Android/iOS
*	WebView/CEF
	(Гибридные приложения)
	*	Обертка для веб-приложений на базе Chromium Embedded Framework (CEF)
	*	Готовые веб-решения
	*	Быстрый старт для WEB
	*	Доступ к API ОС через C++
	*	Выбрать, если:
		*	Есть WEB-версия приложения
		*	Нужен MVP за короткий срок
*	PWA
	(Прогрессивные веб-приложения)
	*	Веб-приложения, работающие как нативные (доступно с Аврора 5.2)
	*	Офлайн-режим
	*	Установка через браузер
	*	Интеграция с сервисами
	*	Выбрать, если:
		*	Нужен быстрый порт существующего WEB-приложения
		*	Ограниченный бюджет на разработку
	*	Будет доступен в ОС Аврора 5.2
