# Операционные системы и подходы к разработке

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

Начнём наш курс со знакомства с операционной системой.

## Мобильное устройство для пользователя

Мобильные устройства — ряд устройств, который включает в себя смартфоны, планшеты, электронные
книги, телефоны, КПК и нетбуки, главной особенностью которых является размер, а также количество
выполняемых ими функций.
Смартфоны — устройства, важной особенностью которых является размер и способность
к транспортированию, а также большой ряд функциональных возможностей.

*	Связь: телефон, сообщения.
*	Мультимедиа.
*	Дата / время: часы, будильники, напоминания, календарь.
*	Персональный цифровой помощник.
*	Игры.

Основной недостаток мобильных устройств — необходимость постоянного следить за уровнем заряда
и мощностью сигнала связи.

## Мобильная ОС для пользователя

Работоспособность мобильного устройства обеспечивает программное обеспечение, которое управляет
устройством, т.е. операционная система.

Сегодня основными мобильными операционными системами являются:

*	Android.
	Данная операционная система по праву считается самой популярной в мире среди аналогичных
	продуктов для различных устройств.
	Согласно официальной статистике, почти 85 процентов всех мировых телефонов, планшетов
	и смартфонов работают именно на Android.
*	IOS.
	Фирменная разработка компании Apple, которая работает только на устройствах,
	производимых этой же корпорацией.
	Пользовательский интерфейс iOS основан на концепции прямого взаимодействия с использованием
	жестов «мультитач».
	Элементы управления интерфейсом состоят из ползунков, переключателей и кнопок.
	Впервые операционная система была представлена в 2007 году.

ОС, которая будет изучаться в этом курсе, — Аврора, разрабатываемая компанией
"Открытая мобильная платформа".

*	Ориентированный на жесты UX, полная многозадачность.
*	Уважение к конфиденциальности данных.
*	B2B и B2G, функции MDM и российские ГОСТы.

У каждой операционной системы имеется сообщество разработчиков под эту ОС, откуда можно почерпнуть
немало практической информации.

## Мобильное устройство для разработчика

Разработчики мобильных приложений должны учитывать информацию о следующих особенностях ОС.

*	Технические характеристики устройств, на которых приложение будет запускаться.
	В частности, нередко приходится следить за потреблением энергии и/или доступными сетями,
	чтобы обеспечить корректную работу с данными и другие функции приложения.
*	Мультимедийные функции: аудио, видео: запись и вывод, радио.
*	Сетевые соединения: работа с удалёнными сервисами.
*	Доступные датчики: работа с системными датчиками устройства.

При создании приложения также необходимо определить целевую аудиторию, чтобы ориентировать своё
приложение именно на неё.
Для этого важно знать, какими бывают пользователи мобильных приложений, а также в чем заключаются
их интересы и потребности.

## Мобильная ОС для разработчика

Для разработки необходимо учитывать такие особенности платформ и мобильных приложений:

*	Архитектура целевых устройств.
*	UI / UX.
	У каждой мобильной платформы имеются рекомендации к интерфейсу, которые следует соблюдать,
	чтобы упростить использование своего приложения.
*	API. Он является открытым, в большинстве случаев хорошо документированным.
*	Инструменты разработки: среда, эмуляторы устройств.
*	Оформление документации своего приложения.
*	Инструменты публикации приложения.

Хорошим источником информации является сообщество разработчиков.

Android

*	Ядро Linux
*	Java байт-код в виртуальной машине, собственный API
*	Инфраструктура Google

iOS

*	Гибридное ядро XNU
*	POSIX-совместимые компоненты Darwin
*	Инфраструктура Apple

ОС Аврора

*	Полнофункциональный Linux
*	POSIX-совместимое пользовательское пространство
*	Независимая портативная инфраструктура

## Технологии разработки

Часто используемые средства разработки:

*	Android: Android Studio (языки Java, C/C++, Kotlin).
*	iOS: Xcode (языки Objective-C, Swift).
*	ОС Аврора: Аврора SDK (языки C/C++, QML, Python).

Также имеется несколько кроссплатформенных технологий, которые позволяют создавать приложения,
не привязываясь к конкретной ОС или адаптируя для ОС только часть приложения, например, внешний вид.

## Кроссплатформенные технологии

На слайде перечислены различные кроссплатформенные технологии.

*	WEB-технологии (JavaScript, HTML 5, CSS).
*	Flutter - фреймворк с открытым исходным кодом для создания мобильных приложений.
*	Kotlin MultiPlatform позволяет совместно использовать код на различных платформах.
*	Qt (C++, QML, JavaScript) — изучается в нашем курсе.
	*	Эффективные собственные приложения с декларативным интерфейсом.
