# Уведомления

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QML-плагин Notifications

QML-плагин Notifications предоставляет классы C++/QML для публикации уведомлений в среде Lipstick.

Тип Notification - это удобный тип для использования уведомлений на основе спецификации уведомлений
рабочего стола.
Этот тип позволяет клиентам создавать экземпляры уведомлений, которые можно использовать для связи
с диспетчером уведомлений Lipstick через D-Bus.
Это упрощает процесс создания, перечисления и закрытия уведомлений, поскольку необходимые сообщения
обрабатываются по типу.
Содержимое уведомлений можно указать, задав различные свойства в экземпляре типа Notification,
или обработать, указав категорию, свойства которой автоматически применяются диспетчером
уведомлений Lipstick для соответствующих уведомлений.
Свойства, установленные в экземпляре уведомления, не будут перезаписаны значениями, указанными в категории.

## Notification — уведомление

Основные свойства уведомления.

*	body : string - дополнительный подробный основной текст.
*	replacesId : int - идентификатор, который следует использовать для замены или удаления этого уведомления.
	Если уведомление опубликовано с ненулевым идентификатором, оно заменит любое существующее
	уведомление с этим идентификатором, не предупреждая пользователя о каких-либо изменениях.
	Неопубликованное уведомление имеет нулевой идентификатор.
	Идентификатор автоматически обновляется и содержит опубликованный идентификатор после публикации
	уведомления диспетчером уведомлений.
*	summary : string - краткий текст с описанием уведомления.
	Резюме должно содержать краткое однострочное описание уведомления.
*	previewBody : string  - основной текст для отображения в баннере предварительного просмотра для уведомления.
*	previewSummary : string - короткий текст для отображения в баннере предварительного просмотра для уведомления.
	Если указаны previewSummary или previewBody, Lipstick при публикации будет генерировать
	предварительный просмотр уведомления (если менеджер уведомлений не решит подавить предварительный просмотр).
*	icon : string - значок уведомления.
	Значением может быть URI, абсолютный путь к файловой системе или токен, который должен интерпретироваться
	поставщиком изображения темы.
	Он может иметь приоритет над appIcon в зависимости от реализации платформы.
*	timestamp : date - временная метка обычно связана с событием, к которому относится уведомление,
	а не с созданием самого уведомления.
	Если не указано, отметка времени уведомления станет временем публикации.

## Пример отправки уведомления

Минимальный пример использования этого типа в приложении QML представлен на слайде.
 
При нажатии кнопки новое уведомление публикуется в диспетчере уведомлений, свойства которого
указаны в определении объекта уведомления.
Любые свойства, указанные в файле определения для назначенной категории, будут автоматически
применены менеджером уведомлений во время публикации.
Менеджер выделяет идентификатор для уведомления, а экземпляр обновляется, чтобы этот идентификатор
отражался в свойстве replacesId.
Приложение может получить этот идентификатор по одноимённому свойству.

## Управление отображением уведомления

*	appName : string - имя приложения, связанное с этим уведомлением, для целей отображения.
	Имя приложения должно быть формальным именем, локализованным, если необходимо.
*	appIcon : string - иконка приложения, с которым связано это уведомление.
	Значением может быть URI, абсолютный путь к файловой системе или токен, который должен
	интерпретироваться поставщиком изображения темы.
*	category : string - категория, свойства которой должны применяться к уведомлению диспетчером уведомлений.
	Свойства, определенные в файле определения категории, будут применяться к уведомлению, если только
	эти свойства уже не установлены в уведомлении.
*	itemCount : int - количество элементов, представленных в уведомлении.
	Например, одно уведомление может представлять четыре пропущенных вызова, если установить счетчик на 4.
	По умолчанию 1.
*	expireTimeout : int - количество миллисекунд после отображения, при котором уведомление должно автоматически закрываться.
	Нулевое значение указывает, что уведомление не должно закрываться автоматически, в то время как -1 указывает,
	что диспетчер уведомлений должен принять решение об истечении времени ожидания.
	По умолчанию -1.
*	isTransient : int - свойство, предполагающее, что уведомление должно показываться только кратко.
*	maxContentLines : int - свойство, предлагающее максимальный объем контента для отображения в уведомлении.
	Строки содержимого включают в себя итоговую строку, поэтому в однострочном уведомлении не отображается основной текст.
*	urgency : enumeration - уровень срочности уведомления.
	Уровень срочности интерпретируется менеджером уведомлений при публикации.
	Он может принять решение об отображении или подавлении отображения уведомления в зависимости
	от текущей пользовательской активности или состояния устройства, где с большей вероятностью будут
	отображаться уведомления с критической срочностью.
	По умолчанию срочность Normal.

## Выполнение действий по уведомлениям

*	remoteActions : list<variant> - удаленные действия зарегистрированы для потенциального вызова этим уведомлением.
	Удаленные действия указываются в виде списка объектов, имеющих свойства 'name', 'service', 'path', 'iface'
	и 'method', и, опционально, свойства 'displayName', 'icon' и 'arguments'.

Текущая реализация Lipstick будет вызывать действие с именем «default», когда пользователь
активирует отдельное уведомление.
Если пользователь активирует группу уведомлений, будет вызвано действие с именем «app», если это действие
является общим для всех членов группы.

## Пример описания действий уведомления

На слайде приведён пример, как описать одно действие для уведомления.
