# Тесты по теме «Работа с памятью в Qt»

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Single choice

Что такое "визуальный родитель" в классе QQuickItem?

---

*	**Объект, определяющий положение элемента в иерархии видимых компонентов**
*	Родительский объект класса QObject, управляющий жизненным циклом дочернего объекта
*	Специальный механизм автоматического удаления объектов
*	Компонент, который контролирует использование памяти приложением

## Multiple choice

Какие типы памяти используются приложениями, написанными на QML?

---

*	**Куча JavaScript**
*	**Куча C++**
*	Куча Python
*	Куча Qt, создающаяся дополнительно к куче C++

## Single choice

Что произойдет, если удалить объект QObject, имеющий дочерние элементы?

---

*	**Все дочерние объекты будут автоматически удалены**
*	Дочерние объекты останутся существовать отдельно
*	Деструктор выдаст ошибку, если удаление произошло не в правильном порядке
*	Дочерние объекты станут видимыми корневыми элементами

## Single choice

Где используется концепция дерева иерархии объектов в Qt?

---

*	**Для управления памятью и временем жизни объектов**
*	Только для внутренних нужд фреймворка, разработчик с ней не работает
*	Исключительно для оптимизации производительности графики
*	Для взаимодействия с базой данных

## Single choice

По какому принципу работает эвристический алгоритм запуска сборщика мусора в JavaScript?

---

*	**При достижении заранее заданного объёма зарезервированной памяти и других подобных условий**
*	Регулярно каждые n секунд
*	По достижению фиксированного лимита свободной памяти
*	Автоматически, когда обработана половина стека вызовов функций
