# Работа с памятью в Qt

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Особенности работы с памятью в QML-приложении

Приложение, написанное на QML, использует память как из кучи C++, так и из автоматически управляемой кучи JavaScript.
Часть памяти будет выделяться обязательно, поскольку она управляется движком QML или движком JavaScript, в то время как остальная часть зависит от решений, принятых разработчиком приложения.

## Иерархии Qt-объектов

Qt поддерживает иерархии объектов.
Для визуальных элементов эти иерархии представляют собой порядок расположения самих элементов, для невидимых элементов они просто выражают «владение» объектами.

При создании объекта QObject с другим объектом в качестве родительского он добавляется в список children() родительского объекта и удаляется при удалении родительского объекта.
Такой подход очень хорошо подходит для объектов графического интерфейса.

QQuickItem, базовый визуальный элемент модуля Qt Quick, наследует QObject, но имеет концепцию визуального родителя, отличную от концепции родителя QObject.
Визуальный родитель элемента может не совпадать с его родительским объектом.

## Удаление Qt-объектов

Можно самостоятельно удалять дочерние объекты, и они сами удалятся из родительских.

Когда объекты QObject создаются в куче (т.е. создаются с помощью оператора new), из них можно построить дерево иерархии в любом порядке, и впоследствии объекты в дереве могут быть уничтожены в любом порядке.
При удалении любого объекта QObject в дереве, если у него есть родительский объект, деструктор автоматически удаляет его из родительского объекта.
Если у объекта есть дочерние объекты, деструктор автоматически удаляет каждый дочерний объект.
Ни один объект QObject не удаляется дважды, независимо от порядка уничтожения.

## Управление памятью в QML и JavaScript

Движок JavaScript в QML имеет специальный менеджер памяти, который запрашивает адресное пространство у операционной системы блоками по несколько страниц. Объекты, строки и другие управляемые значения, созданные в JavaScript, затем помещаются в это адресное пространство, используя собственную схему выделения памяти движка JavaScript.

Зарезервированное адресное пространство не выделяется в физическую память немедленно. Вместо этого операционная система замечает фактическое обращение к странице памяти и только после этого выделяет её. Таким образом, адресное пространство практически свободно, и его большой объём даёт диспетчеру памяти JavaScript необходимое преимущество для эффективного размещения объектов в куче JavaScript.

## Сборщик мусора в QML и JavaScript

Все значения, хранящиеся в куче JavaScript, обрабатываются сборщиком мусора. Ни одно из значений не удаляется немедленно при выходе из области действия. Только сборщик мусора может удалить значения из кучи JavaScript и освободить память.

Сборщик мусора запускается либо вручную, путём вызова функции gc(), либо с помощью эвристического алгоритма, который учитывает следующие аспекты:

*	Объём памяти, управляемой объектом в куче JavaScript, но не выделенной напрямую в куче JavaScript, например, строками и внутренними данными-членами классов. Для них поддерживается динамический порог. При его превышении запускается сборщик мусора, и порог увеличивается. Если объём управляемой внешней памяти значительно ниже порога, порог уменьшается.
*	Общее зарезервированное адресное пространство. Выделение внутренней памяти в куче JavaScript учитывается только после того, как будет зарезервирована хотя бы часть адресного пространства.
*	Дополнительное зарезервированное адресное пространство с момента последнего запуска сборщика мусора. Если объём адресного пространства более чем вдвое превышает объём использованной памяти после последнего запуска сборщика мусора, сборщик мусора запускается повторно.

## Работа с памятью в QML

Типы, основанные на QObject, и, в частности, всё, что является элементом QML, размещаются в куче C++.
При обращении к QObject из JavaScript в кучу JavaScript помещается лишь небольшая обёртка вокруг указателя.
Однако такая обёртка может владеть QObject, на который она указывает. 
Если обёртка владеет объектом, он будет удалён при сборке мусора.

Также можно вручную инициировать удаление, вызвав метод destroy(). Метод destroy() вызывает QObject::deleteLater(). Поэтому он не удаляет объект немедленно, а ждёт следующей итерации цикла событий.

Свойства объектов, объявленные в QML, хранятся в куче JavaScript. Они существуют до тех пор, пока существует объект, которому они принадлежат. После этого они удаляются при следующем запуске сборщика мусора.

В JavaScript любой структурированный тип является объектом. При создании объекта диспетчер памяти выделяет для него определённое место в куче JavaScript.

Строки JavaScript также являются управляемыми значениями, но их строковые данные не размещаются в куче JavaScript. Подобно обёрткам QObject, объекты в куче для строк представляют собой лишь тонкие обёртки вокруг указателя на строковые данные.
