# LocalStorage

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## База данных по умолчанию

Базы данных используются во множестве приложений, требующих работы с данными пользователя. 

В Qt по умолчанию встроена база данных SQLite.
Движок этой базы данных не является отдельно работающим процессом, с которым взаимодействует программа.
По сути, это небольшая библиотека на C, которая реализует автономный, встраиваемый механизм базы данных
SQL с нулевой конфигурацией.
Такой подход уменьшает время отклика и сильно упрощает программу.
SQLite хранит всю базу данных в едином файле на хосте.

Для того, чтобы работа с SQLite стала доступна в QML документе, необходимо импортировать
модуль QtQuick.LocalStorage.

## Начало работы с базой данных

Соединения с базой данных открываются с помощью глобального объекта синглтона LocalStorage.
На нем вызывается метод openDatabaseSync(), который непосредственно открывает соединение
с существующей базой или создает базу, если она не существовала ранее.
Методу передаётся список параметров, содержащих освновную информацию о базе данных - имя, версия,
описание, предполагаемый размер и callback функция, вызов которой создает новую базу данных. 

Обязтельными являются первые два аргумента - чтобы знать, какую базу данных необходимо открыть,
и ее текущую версию, чтобы иметь возможность обновить схему базы данных.

## Обращение к базе данных 

Кроме метода, открывающего базу данных, есть также функции для обращения к ней. 

Каждое обращение к базе представляет собой транзакцию, внутри этой транзакции можно выполнить
несколько последовательных операций.

Метод readTrasaction создает транзакцию только на чтение данных из базы.
Метод transaction создает транзакцию чтения или записи данных.
Далее методы передаются в функцию обратного вызова с аргументом tx, который необходим
для выполнения SQL-операций.

Одновременно может быть создано несколько транзакций на чтение данных, поскольку они не влияют
на содержимое базы данных.
Однако в случае транзакции на чтение и запись в один момент времени может быть проведена только
одна такая транзакция, чтобы исключить конфликты, а также считывание неактуальных данных. 

Метод ExecuteSql вызывается на объекте tx, он принимает SQL запрос в виде строки, а также набор
передаваемых в запрос аргументов и возвращает объект со свойствами, значения которых зависят
от выполняемой операции. 

Для SQL запроса SELECT доступны свойства rows.length, содержащее количество строк в результате,
а также rows.item(i), содержащее объект с i-ой строкой. 

rowsAffected доступно для запросов UPDATE и DELETE и содержит количество строк, затронутых
изменениями в результате выполнения запроса. 

insertId содержит id строки, вставленной в базу данных и доступно для запроса NSERT. 

## Объект для работы с базой данных

Для удобного использования LocalStorage можно создать отдельный qml-документ с описанием всех
функций для взаимодействия с базой данных.
Обычно создается файл с описанием собственного объекта доступа к данным DAO — data access object.
На слайде приведена часть кода файла Dao.qml, где мы описали базу данных, содержащую информацию
о списке книг. 

В корне файла определяем компонент QtObject, в его теле задаем свойство db, в которую мы поместим
экземпляр базы данных. 

Операции по созданию БД и ее инициализации необходимо помещать внутри обработчика сигнала
Component.onCompleted для выполнения в момент создания объекта Dao.
Здесь мы открываем базу данных и помещаем ее в свойство db, а также вызываем метод createBooksTable,
который создаст базу данных, если мы работаем с приложением впервые. 

Метод createBooksTable работает следующим образом: на объекте db запрашивается транзакция, которая
передается в callback-функцию с аргументом tx.
На tx вызывается метод executeSQL, куда мы передаем SQL запрос CREATE для таблицы books
с 4 полями - id, автор, название и количество страниц. 

Все транзакции автоматически закрываются при сборке мусора.

С описанием методов insertBook, updateBook и deleteBook мы познакомимся в следующем уроке. 

## Миграция базы данных 

В процессе разработки приложения может меняться структура базы данных.
Для того, чтобы перейти от одной версии к другой необходимо осуществить миграцию.

Перед тем, как осуществлять миграцию, необходимо подключиться к базе данных и проверить ее версию
с помощью свойства version.
В зависимости от текущей версии исполняется тот или иной код с помощью метода changeVersion().
В данный метод передаются три аргумента - текущая версия баззы данных, та версия, до которой
необходимо обновиться и функция для вызова SQL операции.

В примере на слайде мы осуществляем миграцию базы данных books до версии 1.1
и добавляем в нее новую строку.

## Запросы SELECT и DELETE

Давайте посмотрим примеры Java Script функций, с помощью которых можно выполнять стандартные
SQL запросы, а также заполнять модель данных. 

Метод, retrieveBook, позволяющий извлечь информацию из базы данных, принимает на вход callback,
функция, которая будет вызвана после получения записей из таблицы.
В теле метода мы создаем readTransaction, результат выполнения SQL запроса помещаем в переменную
result, в данном случае все записи из таблицы.
Затем передаем данные о строках таблицы в аргумент callback функции. 

Для удаления записи из таблицы опишем метод deleteBook, куда передадим в качестве аргумента id
удаляемой записи.
Создается транзакция для записи и метод executeSql вызывает запрос DELETE. 

## Запросы INSERT и UPDATE

Чтобы добавить новую запись, создадим метод insert Book, где в аргументах передадим информацию
о книге и добавим ее в таблицу с помощью метода INSERT. 

Для обновления одной записи таблицы по id опишем метод updateBook, в аргументах укажем id
и новые значения для записи.
В методе executeSql передадим запрос UPDATE. 

## Запрос с вычисляемым полем

Для запроса с вычисляемым полем в аргументе функции зададим callback, который вернет нам
необходимый результат.
В данном случае суммарное количество страниц всех книг, содержащихся в базе данных.
В переменную result сохраняем результат выполнения SQL запроса и передаем его callback-функции.

## Заполнение модели данных

Использование LocalStorage можеть быть удобно в построении моделей данных.
Поскольку в базе данных хранится однородная информация, в качестве модели можно выбрать ListModel.

У нас уже описан метод retrieveBooks, позволяющий выбрать все записи из таблицы.
Теперь нам необходимо этими данными заполнить модель. 

В QML-документе, где описана модель создадим объект типа Dao, чтобы иметь доступ к его методам
и опишем функцию selectBooks, являющуюся своего рода обработчиком, позволяющим извлечь данные
из таблицы в удобном формате. 

Для начала очистим нашу модель, чтобы не появлялось дублирующх данных. 

Затем вызовем метод retrieveBooks на объекте Dao.
В параметр передаем callback-функцию.
Извлеченные данные будут находиться в JavaScript массиве books. 

Организуем цикл по массиву, и данные каждого извлеченного объекта добавляются к  ListModel
с помощью метода append().
Эти поля будут являться свойствами модели.

К этим свойствам можно получить доступ внутри делегата, в нашем примере мы выводим в Label
информацию о книге и ее авторе. 

Функция selectBooks() вызывается в обработчике сигнала Component.onCompleted компонента Page.
Таким образом наполнение данными будет произведено только в момент, когда страница будет создана.

Обратите внимание, что после вызова любого метода, связанного с изменениями в таблице, необходимо
вызвать функцию selectBooks, чтобы измененные данные также отобразились в модели и были видны пользователю.
