# Тесты по теме «Локальные файлы»

Copyright&nbsp;©&nbsp;2016–2024 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Matching

Сопоставьте классы и их основную функциональность

---

|                  |                                    |
|------------------|------------------------------------|
| `QIODevice`      | Абстрактный класс для ввода/вывода |
| `QFile`          | Работа с файлами                   |
| `QFileInfo`      | Информация о файле                 |
| `QDir`           | Работа с каталогами                |
| `QTemporaryFile` | Управление временными файлами      |

## Single choice

Какие разделители путей поддерживает `QFile`?

---

*	**/**
*	\
*	\\
*	:\\

## Single choice

Какой поток используется для чтения и записи бинарных файлов?

---

*	`QTextStream`
*	**`QDataStream`**

## Multiple choice

Какой путь можно указывать к каталогу в `QDir`?

---

*	**Абсолютный**
*	**Относительный**

## Single choice

```qml
import Nemo.FileManager 1.0
FileModel {
    id: fileModel
    path: StandardPaths.home
    ...
}

SilicaListView {
    model: fileModel
}
```

Что будет выведено в представлении?

---

*	Список, содержащий стандартную директорию Home.
*	**Список из содержимого стандартной директории Home.**

## Multiple choice

Какие свойства `StandardPaths` могут быть пустыми?

---

*	`genericData`
*	`music`
*	**`download`**
*	`data`
*	`documents`
*	**`cache`**
*	`videos`

## Single choice

Для чего используются `Pickers`?

---

*	Для выбора даты и времени.
*	Для выбора цвета.
*	**Для выбора мультимедиа контента в файловой системе.**
*	Для переноса контента при разработке.
*	Для удаления элементов.

## Single choice

```qml
ListModel {
    id: standardPathsModel

    Component.onCompleted: {
        append({
            name: qsTr("Video"),
            path: StandardPaths.videos
        });
        append({
            name: qsTr("Home"),
            path: StandardPaths.home
        });
    }
}

...

SilicaListView {
        model: standardPathsModel
        ...
        delegate: IconTextListItem {
            text: model.name
            icon.source: model.icon
            ...
        }
}
```

Что будет выведено в представление?

---

*	**Список из стандартных директорий Video и Home.**
*	Список из содержимого стандартных директорий Video и Home.

## Single choice

```js
var result = tx.executeSql("SELECT SUM(pagesNumber) AS pSum FROM BooksTable WHERE price > 10");
```

Как можно получить число — результат суммирования?

---

*	**`result.rows.item(0).pSum`**
*	`result.rows.item(0).sum`
*	`result.pSum`
*	`result.pSum(0)`

## Single choice

Обязательно ли знать путь к директории с определенным типом данных для его указания?

---

*	Да, во всех случаях обязательно.
*	**Нет, можно воспользоваться `StandardPaths` для стандартных директорий файлов.**

## Single choice

Может ли пользователь выбрать несколько видеофайлов для воспроизведения с помощью одного диалога?

---

*	Нет, придётся несколько раз использовать диалог `VideoPickerPage`.
*	**Да, можно выбрать несколько файлов в диалоге `MultiVideoPickerDialog`.**

## Single choice

Если мы вернемся на уже сохраненную страницу `MultiImagePickerDialog`, сохранятся ли на ней метки на выбранных элементах?

---

*	**Да**
*	Нет

## Single choice

```js
var result = tx.executeSql( "SELECT * FROM BooksTable WHERE isFinished = ? ORDER BY id ASC", [isFinished]);
```

Что из себя представляет `result`?

---

*	Двумерный массив, соответствующий запрошенной таблице.
*	Список объектов, соответствующих записям таблицы.
*	**Объект со свойством rows, содержащим записи таблицы.**
*	Объект с методом rows(), который возвращает записи таблицы.

## Multiple choice

К каким директориям приложение будет иметь доступ без дополнительных разрешений?

---

*	**~/.config/{доменное_имя}/{название_приложения}**
*	**/srv/shared/{доменное_имя}/common**
*	~/Documents
*	/home
