# Локальные файлы

Copyright&nbsp;©&nbsp;2016–2024 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Классы для работы с файлами

Работа с директориями и файлами — это та область, в которой не все операции платформонезависимы,
поэтому Qt предоставляет собственную поддержку таких операций, которая базируется на следующих классах:

*	QIODevice — абстрактный класс для ввода/вывода;
*	QFile — для работы с файлами;
*	QFileInfo — для получения различной информации о файле;
*	QDir — для работы с каталогами.

О функциональности этих классов мы и поговорим. 

## QIODevice — основа ввода-вывода

Класс QIODevice — это абстрактный класс, обобщающий различные устройства ввода/вывода.
Реализация конкретного устройства происходит в унаследованных классах, например QFile.
QIODevice содержит виртуальные методы для открытия и закрытия устройства ввода/вывода,
а также для чтения и записи блоков данных или отдельных символов.

Считывать и записывать данные можно с помощью методов read и write.
Для чтения всех данных сразу определен метод readAll(), который возвращает их в объекте типа QByteArray.
Строку или символ можно прочитать методами readLine и getChar соответственно.

В классе QiODevice определен метод для смены текущего положения: seek.
Получить текущее положение можно вызовом метода pos. 

Чтобы проверить, какие операции доступны при работе с устройством,
следует воспользоваться методами isReadable() и isWriteable() .

Для работы с устройством его необходимо открыть в одном из режимов, например ReadOnly, WriteOnly,
ReadWrite и другие.
Для того чтобы в любой момент времени исполнения программы узнать, в каком из режимов было открыто
устройство, нужно вызвать метод openMode().

## QFile — чтение и запись в файл

QFile — это устройство ввода-вывода для чтения и записи текстовых и двоичных файлов и ресурсов.

Файл открывается с помощью open и  закрывается с помощью close.
Данные обычно читаются и записываются с использованием QDataStream или QTextStream,
но также можно вызывать унаследованные от QIODevice методы read(), readLine(), readAll(), write().

flush() сбрасывает любые буферизованные данные в файл.

Имя файла обычно передается в конструкторе, но его также можно установить с помощью метода setFileName.
QFile ожидает, что разделителем файлов будет «/» независимо от операционной системы.
Использование других разделителей (например, «\») не поддерживается.

Вы можете проверить существование файла с помощью метода exist() и удалить файл с помощью remove().

Для безопасного создания уникальных временных файлов используется класс QTemporaryFile.
Имя временного файла гарантированно будет уникальным (то есть вы не перезапишете существующий файл),
и этот файл будет впоследствии удален после уничтожения объекта QTemporaryFile.
Этот механизм позволяет избежать повреждения данных для приложений, которые хранят
их во временных файлах.

## Пример чтения и записи в файл

Пример считывает текстовый файл построчно.

Флаг QIODevice::Text, передаваемый методом open(), указывает Qt преобразовать терминаторы строки
в стиле Windows ("\r\n") в терминаторы стиля C ++ ("\n").
По умолчанию QFile предполагает двоичный формат, то есть он не выполняет никакого преобразования
байтов, хранящихся в файле.

Классы файлов сами по себе обладают только элементарными методами для чтения и записи информации.
Задействование потоков делает запись и считывание файлов более простым и гибким.
Для файлов, содержащих текстовую информацию, следует воспользоваться QTextStream,
а для двоичных файлов — QDataStream.
Для записи данных в поток служит оператор <<, а для чтения данных из потока — >>.

## QfileInfo — информация о файле

QFileInfo предоставляет  независимую от системы информацию о файле - имя,
путь к нему в файловой системе, является ли файл каталогом или символической ссылкой,
время последнего изменения, атрибуты доступа, размер и т. д.
QFileInfo также можно использовать для получения информации о ресурсе Qt.

Файл, c которым работает QFileInfo,
устанавливается в конструкторе или с помощью метода setFile().

## QDir — работа с директориями

QDir используется для работы с именами путей, доступом к информации о путях и файлах,
а также с основной файловой системой.
Он также может быть использован для доступа к системе ресурсов Qt .

QDir может указывать на файл, используя относительный или абсолютный путь.
Абсолютные пути начинаются с разделителя каталогов.
Относительные имена файлов начинаются с имени каталога или имени файла и указывают путь
относительно текущего каталога.

Путь к каталогу можно получить с помощью функции path, а установить новый
путь - с помощью функции setPath.

Имя каталога можно найти с помощью метода dirName. 

Путь к каталогу также можно изменить с помощью функций cd() и cdUp(), которые работают
как обычные команды оболочки. 

Создавать каталоги можно с помощью mkdir(), переименовывать с помощью rename()
и удалять с помощью rmdir().

Доступ к некоторым общим каталогам обеспечивается рядом статических функций,
которые возвращают объекты QDir.

*	current() — рабочий каталог приложения;
*	root() — корневой каталог;
*	temp() — временный каталог операционной системы;
*	home() — домашняя директория пользователя.

## Пример работы с директорией

На слайде приведён пример обхода каталогов и чтения файла.

Сначала мы обращаемся к корневому каталогу и пробуем сменить каталог на tmp.
Если удалось переместиться в tmp, в этом каталоге мы создаём и открываем для чтения и записи файл "ex1.txt".

## Доступные директории

Используйте правильные каталоги данных приложения.

OrganizationName и ApplicationName используются для предоставления приложению прав
на запись в директории.

1.	$HOME/.local/share/\<Название организации\>/\<Имя приложения\>
2.	$HOME/.cache/\<Название организации\>/\<Имя приложения\>
3.	$HOME/.config/\<Название организации\>/\<Имя приложения\>

Для доступа к указанным выше каталогам из приложения используйте Aurora::Application::Paths.

1.	Данные приложения - Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::AppDataLocation)
2.	Кеш приложения - Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::CacheLocation)
3.	Конфигурация приложения - Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::ConfigLocation)

Только эти каталоги могут использоваться для хранения данных приложения.

## FileModel — модель со списком файлов

Для отображения списка файлов и директорий в интерфейсе пользователя существует тип
FileModel - наследник QAbstractListModel. Он обладает собственными методами, для изменения текущего
каталога и получения доступа к информации о файле.

Чтобы работать с FileModel, необходимо в QML документе импортировать модуль Nemo.FileManager.

Свойство active -  указывает на активность модели. FileModel активно следит за каталогом.
Если каталог изменяется, то модель обновляется автоматически, если значение active true.

Свойство dir содержит текущую директорию, а fileCount - количество файлов в директории.

Метод refresh() - обновляет модель, selectedFiles - возвращает список выбранных файлов,
а parentPath() -  путь к родительской директории.

## Доступ к данным из StandardPaths

QML-тип StandardPath используется для унификации доступа к файлам внутри системы.
Свойства объекта содержат в себе информацию о базовой директории каждого пользователя.
При работе с файлами устройства рекомендуется прописывать доступ через StandardPaths.

Каждое из перечисленных свойств содержит информацию о хранилищах определенного типа данных
(кэша, документов, загрузок, музыки и др.).

*	Свойство genericData содержит директорию для хранения данных, которые используются между приложениями.
*	Download и cache могут быть пустыми, если директория не определена.
	Другие свойства в таком случае не могут быть пустыми.

## Пример StandardPaths

На слайде можно видеть пример использования StandardPaths и примеры значений.

## Pickers — диалоги выбора файлов

Pickers - это инструменты выбора файлов, которые предназначены для приложений ОС Аврора.

Они делятся на две группы: страницы для выбора одного элемента и диалоги для выбора нескольких файлов.

Picker используются с PageStack. Рекомендуется отправлять Picker на PageStack в качестве компонента
или URL-адреса, чтобы PageStack мог позаботиться о его жизненном цикле.
Каждый Picker хранит выбранный контент до его уничтожения, независимо от того, выбираете ли
вы один или несколько файлов.

Страницы выбора позволяют пользователям выбирать ровно один файл.

Диалоги выбора позволяют пользователям выбирать несколько файлов.
Пользователь может принять диалог, то есть подтвердить выбор и продолжить, нажав "Accept".
И наоборот, пользователь может отклонить диалог, сигнализируя об отмене выбора, используя
жест прокрутки слева направо или нажав "Cancel", который находится в верхнем левом углу диалога.

## Общие свойства для PickerPage

Основные свойства страниц для выбора:

*	selectedContent содержит URL выбранного файла
*	title содержит заголовок страницы.
	Значение по умолчанию зависит от класса компонента, например, "Select file".
*	selectedContentProperties предназначено только для чтения.
	Это свойство содержит основную информацию о выбранном элементе.
	*	fileName - имя файла без пути.
	*	filePath - полный путь к файлу, включая имя файла.
	*	url - filePath в виде url.
	*	title - имя файла, которое может быть извлечено из метаданных файла.
	*	mimeType - тип mime файла, например «image / jpeg», «image / png», «application / pdf», «video / mp4», «audio / mpeg».

## Пример выбора одного файла

В примере на слайде динамически создаётся и загружается в стек страница для выбора аудиофайла.
Далее к сигналу страницы selectedContentChanged, испускаемому после выбора файла пользователем,
подключается в качестве слота функция, которая указывает плееру на выбранный файл как на источник видео
и автоматически запускает восроизведение.

## Общие свойства для PickerDialog

Диалог для выбора содержит дополнительное свойство acceptText,
обозначающий подтверждение выбора пользователем.

## Пример выбора нескольких файлов

В примере на слайде создаем и загружаем диалог для выбора аудиофайлов.
К сигналу accept, подключается функция, которая составляет из выбранных аудиофайлов плейлист
и автоматически запускает воспроизведение плейлиста с начала.

К сигналу  rejected, испускаемому после отказа от выбора, подключается слот,
который очищает плейлист.

## Доступ к директориям

Как уже обсуждалось в модуле про инструменты разработки, в ОС Аврора версии 4.0.1 каждое приложение
запускается в изолированном окружении, которое ограничивает доступ к API и данным.
Директории, которые доступны приложениям для чтения и записи, определяются как названием
установочного пакета, так и разрешениями, перечисленными в .desktop-файле.

Пути к директориям рекомендуется указывать с помощью класса QStandardPaths или QML-типа StandardPaths.
Такой подход позволяет избежать привязок к конкретному приложению или параметрам окружения.

## Директории для приложения

По умолчанию каждое приложение имеет доступ на чтение и запись
только директориям, которые ему соответствуют,
а также общей директории всех приложений одной организации:

* AppConfigLocation - ~/.config/{доменное_имя}/{название_приложения} - Настройки приложения для пользователя
* CacheLocation/cache - ~/.cache/{доменное_имя}/{название_приложения} - Кэш приложения (данные, удаление которых не влият на настройки приложения) для пользователя
* AppDataLocation/data - ~/.local/share/{доменное_имя}/{название_приложения} - Данные приложения для пользователя

Для директорий имеются константы QStandardPaths: AppConfigLocation, CacheLocation и AppDataLocation,
и константы QML-типа StandardPaths: cache и data.

* /srv/shared/{доменное_имя}/{название_приложения} - Данные приложения, общие для всех пользователей устройства (чтение/запись).
	Директория **/srv/shared/{доменное_имя}/{название_приложения}** формируется
	при запуске приложения на устройстве
	и доступна, пока активен хотя бы один экземпляр приложения.
* /srv/shared/{доменное_имя}/common - Общие данные всех приложений организации (чтение/запись).
	Директория **/srv/shared/{доменное_имя}** формируется
	при запуске любого приложения организации
	и доступна, пока активен хотя бы один экземпляр любого приложения организации.
* /usr/share/common/{доменное_имя}/{название_приложения} - Директория для хранения данных
	между всеми приложениями одного вендора с возможностью распаковки данных при установке пакета (только чтение).

## Общие директории пользователя

Для доступа к общим директориям пользователя
необходимо указать разрешения в .desktop-файле.

Несмотря на то, что разрешение UserDirs может использоваться
для доступа ко всем перечисленным директориям пользователя,
не рекомендуется его указывать,
если нет необходимости работать со всеми директориями.

## Qt.openUrlExternally

Пытается открыть указанный целевой URL-адрес во внешнем приложении на основе настроек рабочего
стола пользователя.
Возвращает true в случае успеха, false в противном случае.

Возвращаемое значение true указывает на то, что приложение успешно запросило операционную систему
на открытие URL-адреса во внешнем приложении.
Внешнее приложение может по-прежнему не запускаться или открывать запрошенный URL-адрес.
Этот результат не будет возвращен в приложение.

## QDesktopServices

Многие среды рабочего стола предоставляют службы, которые могут использоваться приложениями
для выполнения общих задач, таких как открытие веб-страницы, таким образом, чтобы они были
согласованными и учитывали предпочтения приложения пользователя.

Класс QDesktopServices содержит функции, предоставляющие этим службам простые интерфейсы,
указывающие, успешно ли они выполнились или нет.

Функция openUrl() используется для открытия файлов, расположенных по произвольным URL-адресам,
во внешних приложениях.
Для URL-адресов, которые соответствуют ресурсам в локальной файловой системе
(где схема URL-адреса — «файл»), для открытия файла будет использоваться подходящее приложение;
в противном случае для извлечения и отображения файла будет использоваться веб-браузер.

Настройки рабочего стола пользователя определяют, будут ли определенные типы исполняемых файлов
открываться для просмотра или же они будут выполняться вместо этого.
Некоторые среды рабочего стола настроены так, чтобы пользователи не могли запускать файлы,
полученные с нелокальных URL-адресов, или запрашивать разрешение пользователя перед этим.

Поведение функции openUrl() можно настроить для отдельных схем URL-адресов, чтобы приложения могли
переопределять поведение обработки по умолчанию для определенных типов URL-адресов.

Механизм диспетчеризации позволяет использовать только один настраиваемый обработчик для каждой
схемы URL; он устанавливается с помощью функции setUrlHandler().
Каждый обработчик реализован как слот, который принимает только один аргумент QUrl.

## Другие механизмы работы с файлами

QML-модуль Share позволяет загружать пользовательский интерфейс для обмена данными и отображать
список средств отправки.
С помощью этого модуля пользователь имеет возможность делиться файлами и прочим контентом,
отправляя данные любым доступным способом, например, по Bluetooth, SMS, электронной почте и т.д.

D-Bus интерфейс sstore
Криптоконтейнер позволяет пользовательскому приложению хранить информацию в защищённом виде
и тем самым предотвращает неавторизованный доступ нарушителя, получившего доступ к основному
хранилищу, файловой системе устройства.
Цель достигается шифрованием данных с использованием криптографических алгоритмов.
Авторизация доступа к сохранённой информации происходит с использованием пароля.
