# ListView

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Список ListView

ListView — вертикальный или горизонтальный список.

ListView отображает данные из моделей, созданных на основе встроенных типов QML,
таких как ListModel и XmlListModel, или пользовательских классов моделей, определенных
в C++ и унаследованных от QAbstractItemModel или QAbstractListModel.

Элементы в ListView располагаются горизонтально или вертикально.
Список поддерживает прокрутку, поскольку ListView унаследован от Flickable.

Основные свойства:

*	model : model — модель с данными;
*	delegate : Component —  делегат, отвечающий за представление элемента модели;
*	currentItem : Item —  текущий элемент в представлении;
*	currentIndex : int — индекс текущего элемента;
*	count : int — общее количество элементов в модели.

## Переиспользование элементов

Начиная с версии 5.15, ListView можно настроить на повторное использование элементов
вместо создания экземпляров из делегата при каждом добавлении новых элементов в представление.
Такой подход повышает производительность в зависимости от сложности делегата.
Повторное использование элементов по умолчанию отключено (из соображений обратной совместимости),
но его можно включить, установив свойство reuseItems в значение true.

При извлечении элемента из делегата он перемещается в пул повторного использования, представляющий
собой внутренний кэш неиспользуемых элементов.
При этом генерируется сигнал ListView::pooled.
Аналогично, при возвращении элемента из пула генерируется сигнал ListView::reused.

Все свойства элемента, полученные из модели, обновляются при его повторном использовании.
Они включают индекс и строку, а также все роли модели.

Пока элемент находится в пуле, он может быть активен и реагировать на подключенные
сигналы и привязки.

## Кэширование

cacheBuffer определяет, сохраняются ли делегаты за пределами видимой области представления.

Если значение больше нуля, представление может хранить столько экземпляров делегатов, сколько
помещается в указанном буфере.
Например, если в вертикальном представлении высота делегата составляет 20 пикселей, а значение
cacheBuffer равно 40, то может быть создано/сохранено до 2 делегатов выше и 2 делегатов
ниже видимой области.
Буферизированные делегаты создаются асинхронно, что позволяет создавать их в нескольких кадрах
и снижать вероятность пропуска кадров.
Для повышения производительности отрисовки делегаты за пределами видимой области не отрисовываются.

Значение этого свойства по умолчанию зависит от платформы, но обычно больше нуля.
Отрицательные значения игнорируются.

cacheBuffer не является пиксельным буфером — он только сохраняет дополнительные экземпляры делегатов.

Установка свойства не заменяет создание эффективных делегатов.
Это может улучшить плавность прокрутки за счёт дополнительного использования памяти.
Чем меньше объектов и привязок в делегате, тем быстрее прокручивается представление.
Настройка cacheBuffer только отсрочит проблемы, вызванные медленной загрузкой делегатов, а не будет решением.
