# KeepAlive

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QML-плагин KeepAlive

Плагин KeepAlive содержит следующие QML-компоненты для предотвращения блокировки дисплея,
предотвращения приостановки системы и планирования пробуждений из приостановленного состояния:

*	KeepAlive - предотвращение приостановки системы;
*	DisplayBlanking - предотвращение блокировки дисплея;
*	BackgroundJob — планирование пробуждений

## KeepAlive — предотвращение приостановки системы

Свойство enabled устанавливает желаемый режим предотвращения приостановки.
Когда установлено значение true, система не приостанавливается. По умолчанию false.

## DisplayBlanking — предотвращение блокировки дисплея

QML-тип DisplayBlanking предоставляет средства для предотвращения гашения дисплея.

Пока DisplayBlanking.preventBlanking == true, это удерживает систему от автоматического отключения экрана.
Приложение должно установить DisplayBlanking.preventBlanking = false, чтобы снова разрешить гашение экрана.

Текущая видимость отображения задается DisplayBlanking.status.
Это может использоваться, например, для отключения обновлений, когда дисплей выключен. 

## Пример работы

Пример использования: видеоплеер

*	дисплей включен из-за активности пользователя;
*	воспроизведение видео начато;
*	видеоплеер устанавливает DisplayBlanking.preventBlanking = true;
*	воспроизведение видео приостановлено / остановлено;
*	видеоплеер устанавливает DisplayBlanking.preventBlanking = false.

## BackgroundJob — планирование пробуждений

Предоставляет средства для пробуждения / предотвращения приостановки.

Предоставляет абстракцию для планирования задач, которые могут вывести систему из приостановленного
состояния и предотвратить приостановку системы при обработке пробуждения.

*	bool triggeredOnEnable – запуск процесса сразу после включения.
	Это свойство выполняет те же функции, что и triggeredOnStart в стандартных объектах таймера QML:
	установка значения triggeredOnEnable в значение true вызывает срабатывание сразу после включения,
	что может быть полезно, например, для установления исходного состояния.
	По умолчанию имеет значение false.
*	enabled – если значение изменено с false на true, запускается таймер.
	При изменении с true на false остановка таймера / прекращение предотвращения приостановки.
	По умолчанию false.
*	running  - возвращает true, когда таймер сработал (и устройство не может приостановить работу).
*	frequency – частота запуска процесса.
	Устанавливает желаемую частоту пробуждения и запускает таймер.
	Обратите внимание, что пробуждения выровнены общесистемным образом, так что каждый таймер,
	запланированный на одну и ту же частоту, запускается одновременно.
	Фактически это означает, что первое пробуждение, скорее всего, произойдет раньше,
	чем предложенная запрошенная частота.

Диапазон пробуждения:

*	int minimumWait - Устанавливает желаемую минимальную задержку ожидания в секундах и запускает таймер.
*	int maximumWait  - Устанавливает желаемую максимальную задержку ожидания в секундах и запускает таймер.

Обратите внимание, что определение частоты пробуждения является взаимоисключающим с использованием диапазона пробуждения.

Сигнал triggered испускается, когда происходит активация таймера и система не может приостановить работу.

Чтобы снова разрешить приостановку, приложение должно определить обработчик onTriggered и убедиться,
что после обработки задач, связанных с пробуждением, выполняется одно из следующих действий:

*	установить свойство BackgroundJob::enabled в false, чтобы остановить таймер;
*	вызвать метод BackgroundJob::finished() - чтобы запланировать следующее пробуждение.

Методы

*	begin(); 
	Если свойство enabled имеет значение true, переключает BackgroundJob в рабочее состояние
	и испускает сигнал BackgroundJob::triggered().
*	void finished();
	Если свойство enabled имеет значение true, перепланирует таймер пробуждения и прекращает
	предотвращение приостановки.

## Пример BackgroundJob

Пример BackgroundJob, запускающей таймер через 30 секунд.
Таймер перезапускает работу BackgroundJob после окончания своей активности.
