# Введение в IPC

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Межпроцессное взаимодействие

Межпроцессное взаимодействие (Inter-Process communication, IPC) — обмен данными между потоками
одного или разных процессов.
Оно реализуется посредством механизмов, предоставляемых ядром ОС или процессом, использующим
механизмы ОС и реализующим новые возможности IPC.

Также встречаются термины Inter-Thread Communication и Inter-Application Communication.

Межпроцессное взаимодействие является основой для разграничения адресного пространства.
Оно позволяет осуществлять обмен данными между приложениями, которые работают
в различных адресных пространствах.
Общение между приложениями организуется в формате клиент-сервер.
Клиент запрашивает данные.
Сервер предоставляет данные.

## Методы взаимодействия

Распространённые механизмы взаимодействия:

*	файловая система — приложения могут пользоваться одними и теми же файлами;
*	сигналы о произошедших событиях;
*	сокеты TCP — приложения могут обмениваться сообщениями по сети;
*	очередь сообщений и обмен сообщениями между приложениями.

POSIX (Portable Operating System Interface) — набор стандартов, описывающих интерфейсы между операционной системой
и прикладной программой (системный API).
Стандарт создан для обеспечения совместимости различных UNIX-подобных операционных систем
и переносимости прикладных программ на уровне исходного кода.

Механизмы взаимодействия, которые декларируются POSIX:

*	сокеты UNIX domain;
*	каналы (PIPE);
*	именованные каналы;
*	неименованные каналы;
*	семафоры;
*	разделяемая память;
*	утилита nmap.

## IPC в ОС Аврора

В ОС Аврора есть несколько способов организовать взаимодействие между процессами.

Взаимодействие приложений:

*	D-Bus — система межпроцессного взаимодействия, которая позволяет приложениям общаться друг с другом.
*	Share API — пользовательский интерфейс для обмена данными.

Управление жизненным циклом приложения:

*	Фоновые задачи — фоновые процессы, которые необходимы приложениям для обеспечения их собственной функциональности.
*	Интенты — намерения для запуска процесса.

Уведомления:

*	Графические уведомления — уведомления, всплывающие на экране и появляющиеся в списке на экране уведомлений.
*	Push-уведомления — короткие уведомления от сервера на мобильное устройство.

Работа со ссылками:

*	Qt.openUrlExternally — открывает указанный целевой URL-адрес во внешнем приложении.
*	QDesktopServices — простые интерфейсы для работы с URL.
*	URIOpener — работа с URL средствами библиотеки Silica.

## Медиа типы

Во время передачи данных процессы ориентируются на типы данных, которые обозначаются в соответствии со стандартом о медиа типах.
Ранее медиа типы назывались mime-типами.

Медиа тип — это общепринятый стандарт, который описывает формат документа, файла или набора байтов.

Определение типа состоит из типа и подтипа — двух строк, разделённых наклонной чертой (/).
Пример: image/png.

Тип — это общая категория данных, например, аудио, видео, изображение и т.п.
Подтип обозначает конкретный формат данных.

## Qt.openUrlExternally

Пытается открыть указанный целевой URL-адрес во внешнем приложении на основе настроек рабочего
стола пользователя.
Возвращает true в случае успеха, false в противном случае.

Возвращаемое значение true указывает на то, что приложение успешно запросило операционную систему
на открытие URL-адреса во внешнем приложении.
Внешнее приложение может по-прежнему не запускаться или открывать запрошенный URL-адрес.
Этот результат не будет возвращен в приложение.

## QDesktopServices

Многие среды рабочего стола предоставляют службы, которые могут использоваться приложениями
для выполнения общих задач, таких как открытие веб-страницы, таким образом, чтобы они были
согласованными и учитывали предпочтения приложения пользователя.

Класс QDesktopServices содержит функции, предоставляющие этим службам простые интерфейсы,
указывающие, успешно ли они выполнились или нет.

Функция openUrl() используется для открытия файлов, расположенных по произвольным URL-адресам,
во внешних приложениях.
Для URL-адресов, которые соответствуют ресурсам в локальной файловой системе
(где схема URL-адреса — «файл»), для открытия файла будет использоваться подходящее приложение;
в противном случае для извлечения и отображения файла будет использоваться веб-браузер.

Настройки рабочего стола пользователя определяют, будут ли определенные типы исполняемых файлов
открываться для просмотра или же они будут выполняться вместо этого.
Некоторые среды рабочего стола настроены так, чтобы пользователи не могли запускать файлы,
полученные с нелокальных URL-адресов, или запрашивать разрешение пользователя перед этим.

Поведение функции openUrl() можно настроить для отдельных схем URL-адресов, чтобы приложения могли
переопределять поведение обработки по умолчанию для определенных типов URL-адресов.

Механизм диспетчеризации позволяет использовать только один настраиваемый обработчик для каждой
схемы URL; он устанавливается с помощью функции setUrlHandler().
Каждый обработчик реализован как слот, который принимает только один аргумент QUrl.

## URIOpener в Silica

Объект URIOpener позволяет открывать различные URI, например ссылки или файлы, с помощью одного из установленных на устройстве приложений. Это объект-синглтон. Тип URIOpener не может быть создан.

Метод openUri используется для открытия URI без диалога выбора приложения в случае, если имеется только один доступный обработчик или пользователь заранее установил обработчик по умолчанию для локальных файлов с определенным типом MIME.

import Sailfish.Silica 1.0

Page {
    Button {
        text: "Открыть изображение"
        onClicked: URIOpener.openUri(Qt.resolvedUrl("../assets/image.png"))
    }
}
Чтобы обработать результат вызова метода openUri, пользователь может передать методу два обратных вызова:

Первый — это обратный вызов без аргументов, который вызывается при успешном открытии URI.
Второй — обратный вызов, принимающий строку сообщения об ошибке, который вызывается при возникновении ошибки открытия URI.
Метод openUriWith используется для открытия URI с обязательным отображением диалога выбора приложения или диалога ошибки.
