# Эмулятор

Copyright&nbsp;©&nbsp;2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Эмулятор ОС Аврора

Aurora OS Emulator (эмулятор) — виртуальная машина, которая позволяет выполнять приложения в окружении ОС Аврора аналогично работе на мобильном устройстве.

Эмулятор можно запустить из Аврора SDK, нажав нижнюю кнопку в левом нижнем меню в режиме Редактора.

## QEMU эмулятор

Не требует предварительной установки зависимостей.
Собирается на нашей инфраструктуре, поставляется вместе с SDK.
Эмуляция архитектуры ARM.
Поддержка процессоров Apple M Series и Baikal.
Поддержка ускорения OpenGL.

## Управление эмуляторами

Можно установить несколько эмуляторов разных версий ОС Аврора через Maintenance Tool.

Нужно запустить Maintenance Tool из меню приложений компьютера или из каталога AuroraOS, выбрать пункт Добавление или удаление компонентов, отметить галочкой нужные эмуляторы и установить их.

Новый эмулятор будет доступен для развёртывания приложения. Чтобы его выбрать, следует открыть левое нижнее меню сборки и развёртывания и в поле Устройство указать эмулятор из списка.

## Управление моделью эмулятора

Можно изменить модель эмулятора, воспользовавшись верхним меню **Инструменты → ОС Аврора → Режим эмулятора** или **Инструменты → Параметры → ОС Аврора → Режимы эмулятора**.

По умолчанию модели эмулятора соответствуют реальным устройствам, подходящим для установленной версии Аврора SDK. Модель эмулятора задаёт тип устройства, разрешение экрана, ориентации экрана и другие параметры.

Также можно создать собственную модель эмулятора.

## Работа с командной строкой

Авторизация на эмуляторе с правами пользователя:

```bash
ssh -p 2223 defaultuser@localhost
ssh -p 2223 -i ~/AuroraOS/vmshare/ssh/private_keys/sdk defaultuser@localhost
```

Авторизация на эмуляторе с правами суперпользователя:

```bash
ssh -p 2223 -i ~/AuroraOS/vmshare/ssh/private_keys/sdk root@localhost
```

В опции -i указывается путь к закрытому ключу для доступа через SSH. Один ключ используется для всех пользователей.

С помощью утилиты scp и ключа для авторизации можно передавать данные на эмулятор.

Далее приведён пример передачи rpm-пакета, находящегося на компьютере разработчика по пути ./RPMS/.rpm:

```bash
scp -P 2223 -i ~/AuroraOS/vmshare/ssh/private_keys/sdk ./RPMS/<package>.rpm <user>@localhost:
```

## Встраиваемый эмулятор ОС Аврора

Встраиваемый эмулятор ОС Аврора  — это автономный и гибкий инструмент для эмуляции ОС Аврора.

*	Работает без Аврора SDK.
*	Управляется через командную строку.
*	Поддерживает Linux, MacOS, Windows.
*	Поддерживает запуск в CI/CD для тестирования UI приложения.
*	Можно интегрировать в сторонние IDE.
*	Поддерживает запуск x86_64 и aarch64 образов эмулятора.
