# Тесты по теме «D-Bus»

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Multiple choice

Какие данные необходимо получить от сервиса, чтобы подключиться к нему с помощью D-Bus?

---

*	**Название сервиса**
*	**Название интерфейса**
*	**Название определенной функции, которую хотим использовать**
*	**Путь к сервису**

## Single choice

Что такое сервис в контексте работы с D-Bus?

---

*	**Адрес приложения на шине**
*	Набор функций
*	Набор методов
*	Группа методов и сигналов объекта

## Single choice

В чём различие методов QDBusInterface call и typedCall?

---

*	call предназначен для вызова методов интерфейса с массивом в качестве аргумента, а typedCall - для вызова методов интерфейса с массивом объектов в качестве аргумента
*	**call предназначен для вызова методов интерфейса с массивом в качестве аргумента, а typedCall - для вызова методов интерфейса с объектом в качестве аргумента**

## Single choice

```qml
DBusInterface {
	id: dbusList
	service: 'org.freedesktop.DBus'
	path: '/org/freedesktop/DBus'
	iface: 'org.freedesktop.DBus'
	bus: DBus.SessionBus
}
```

Как правильно вызвать метод без аргументов через DBusInterface?

---

*	**dbusList.call("getList", undefined)**
*	dbusList.call("getList")

## Single choice

```qml
DBusInterface {
	id: browser
	service: 'org.sailfishos.browser'
	path: '/'
	iface: 'org.sailfishos.browser'
	function open(url) {
	typedCall('openUrl',{'type': 'as', 'value': [url]},
		function() { console.log('success')},
		function(){console.log('fail') });
	}
}
```

Какой тип данных в качестве аргумента передаётся функции openUrl?

---

*	строка
*	**массив строк**
*	массив символов

## Text

Укажите название поля в секции [X-Application], в котором нужно описать команду
для запуска приложения через D-Bus.

---

ExecDBus
