# D-Bus

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## D-Bus (Desktop Bus)

D-Bus или Desktop Bus — это система, предназначенная для взаимодействия процессов.
Она реализована на уровне операционной системы и предлагает стандартный API для дистрибутивов Linux.

Каждое приложение в системе D-Bus состоит из набора объектов, а сообщения пересылаются
не между приложениями, а между объектами этих самых приложений.

## Сущности D-Bus

Каждый объект имеет группу методов и сигналов.
Каждая такая группа — это отдельный интерфейс объекта.

В D-Bus используются специальные каналы или пути для передачи данных — шины.

*	Системная шина — для взаимодействия демонов
	(приложения без графического интерфейса — системные процессы).
*	Сессионная шина — для приложений с интерфейсом, с которыми взаимодействует пользователь.

При запуске приложение может зарегистрировать набор сервисов, которыми оно будет владеть, пока не освободит.

Сервис — это адрес приложения на шине, по которому оно может быть доступно для других процессов.

Сервисы, зарегистрированные одним приложением, не будут доступны для регистрации другими,
пока приложение их не освободит.

После подключения к шине приложение должно указать, какие сообщения оно желает получать,
путём добавления масок совпадений (matchers).
Маски представляют собой наборы правил для сообщений, которые будут доставляться приложению.
Фильтрация может основываться на интерфейсах, путях объектов и методах.

Сообщения в D-Bus бывают четырёх видов: вызовы методов, результаты вызовов методов,
сигналы (широковещательные сообщения) и ошибки.

В D-Bus у каждого объекта своё уникальное имя, которое выглядит как путь в файловой системе.

Каждый объект может иметь свои методы, параметры, сигналы и слоты.

## Работа с D-Bus из консоли

На слайде приведена сигнатура утилиты dbus-send и пример получения списка доступных dbus-интерфейсов.

## Типы аргументов методов D-Bus

Сигнатура методов D-Bus.

Также как и методы в языках программирования, методы в D-Bus имеют аргументы и возвращаемое значение.

Их тип обозначается специальными сигнатурами, состоящими из символов юникода.
Примитивные типы:
*	y/q/u/t — восьми/шестнадцати/тридцати двух/шестидесяти четырех битный беззнаковый integer соответственно;
*	b — boolean, логический тип;
*	n/i/x — шестнадцати/тридцати двух/шестидесяти четырех битный integer соответственно;
*	d — double, s — string, o — путь объекта D-Bus, a — массив.

Символы могут комбинироваться между собой, например, as — массив строк.

## Интерфейсы D-Bus в ОС Аврора

В ОС Аврора представлены несколько системных программ, предоставляющих D-Bus-сервисы.
Их список периодически расширяется.
Несколько API приведены на слайде.

BlueZ обеспечивает поддержку Bluetooth.
Device Info API предоставляет информацию о параметрах устройства.
IUDID интерфейс для работы с идентификаторами устройств.
Уведомления Lipstick.
NFCD — драйвер устройств NFC.
Reports API генерирует отчёт с логами и информацией о системе.
sstore позволяет приложению хранить информацию в защищённом виде.

## Пример Device Info

На слайде приведён пример обращения к Device Info через консоль.

## Библиотеки для работы D-Bus

В ОС Аврора предусмотрено два варианта взаимодействия с D-Bus.

*	Nemo QML Plugin D-Bus, который позволяет взаимодействовать с D-Bus напрямую из QML кода.
*	Qt D-Bus— стандартный механизм Qt, предоставляющий С++ классы для взаимодействия с D-Bus.

Разница между ними в том, что первый достаточно легок в использовании, а второй предоставляет
больше возможностей.

## DBusInterface — доступ к службам

QDBusInterface имеет свойства:

*	bus — шина, на которой зарегистрирован сервис — системная или сессионная.
	Может принимать значения: DBus.SessionBus, DBus.SystemBus
*	iface — содержит название интерфейса.
	*	path — содержит путь интерфейса.
	*	service — содержит название сервиса.
	*	signalsEnabled — определяет, будет ли объект обрабатывать сигналы интерфейса.

Методы:

*	call — вызвать метод интерфейса.
	Принимает аргументы: method — название вызываемого метода, arguments — массив аргументов,
	передаваемых в вызываемый метод.
	Для функции без аргументов вторым параметром передается undefined.
*	typedCall — вызвать метод интерфейса с объектом в качестве аргумента.
	Принимает аргументы: method — название вызываемого метода, arguments — объект, передаваемый
	в вызываемый метод.
	Объекты задаются вида { ‘type’: ‘тип’, ‘value’: ‘значение’ }.
	callback — функция, выполняемая при успешном вызове.
	Ее параметр содержит значение, возвращаемое вызываемым методом.
	errorCallback — функция, выполняемая при неудавшемся вызове.

## Получение списка служб D-Bus

Создадим приложение для получения списка доступных сервисов.

Приложение должно позволять просматривать список сервисов, зарегистрированных в D-Bus
(как сессионных, так и системных), для каждого такого сервиса просматривать список возможных путей,
для каждого пути — список интерфейсов, а для каждого интерфейса показывать списки методов,
свойств и сигналов.

Для получения списка сервисов, зарегистрированных в D-Bus, используется элемент DBusInterface.
И вызывается метод ListNames описанного интерфейса.

При успешном вызове метода заполняется список сервисов.
При этом происходит фильтрация, чтобы избежать вывода сервисов с именами вида ":1.44" и т.п.

## Пример получения и передачи данных

С помощью D-Bus можно взаимодействовать с системными сервисами.
На слайде представлен пример обращения к сервису "com.nokia.profiled", отвечающему за звуковой профиль.

Методы `get_profiles` и `get_profile` позволяют получить список профилей и текущий звуковой профиль.
А метод `set_profile` позволяет профиль указать.
Тип профиля указывается в списке аргументов для `set_profile` в методе `call`.

## Пример обработки сигналов D-Bus

Чтобы обрабатывать сигналы от сервиса, у компонента DBusInterface нужно включить эту возможность:
установить signalsEnabled как true.
Затем можно обрабатывать событие изменения профиля с помощью функции, совпадающей по имени
с сигналом, например, `profile_changed`.

## Пример использования D-Bus на С++

На слайде приведён пример обращения к D-Bus-службе через C++.

## Для чего нужна своя служба D-Bus

Можно завести собственную службу D-Bus, чтобы реализовывать следующую фукциональность:

*	реакция на действия из уведомлений, например, открытие приложения по нажатию на уведомление;
	*	в том числе обработка Push-сообщений;
*	управление настройками приложения извне.
*	Выполнение особенных функций приложений:
	*	отображение карт и маршрутов;
	*	предоставление данных периферийным устройствам.
*	Открытие файлов или ссылок по запросу извне.

## Собственная служба D-Bus

Провайдер службы (разработчик приложения) декларирует собственную службу D-Bus в Desktop-файле.
Ее имя указывается в ExportDBusInterfaces.
Имя должно совпадать с названием службы, которое регистрируется в C++ или QML-коде.

Клиент декларирует её использование в разрешениях.
Название разрешения составляется из имени службы и имени приложения, предоставляющего её.

## Запуск приложения по D-Bus

Для запуска приложения по D-Bus используется атрибут ExecDBus.
В нём следует указать команду для запуска приложения.

У команды могут быть опции запуска, которые следует обработать в C++-части приложения.
Например, можно не создавать UI при активации по D-Bus.
Имена для опций можно придумать самостоятельно.

## DBusAdaptor — регистрация службы

Объект типа DBusAdaptor используется для создания службы D-Bus на системной или сессионной шине.
Пока служба активна, её можно вызвать из другого приложения.

Тип DBusAdaptor является удобным способом предоставления доступа к объектам через D-Bus.
Значения свойств и аргументы методов автоматически конвертируются между QML/JS и D-Bus.
Управление данным процессом ограничено.
Для более сложных сценариев рекомендуется использовать C++ и модуль Qt DBus.

## Пример службы D-Bus на QML

В примере на слайде продемонстрировано предоставление доступа к объекту по сессионной шине.

Все свойства и методы DBusAdaptor будут доступны через D-Bus.
При этом обнаруживаться через интроспекцию D-Bus будут только те свойства и методы,
которые описаны в свойстве xml.

## Пример службы D-Bus на С++

В примере на слайде продемонстрировано объявление аналогичной службы на C++.

## Внедрение D-Bus сервиса на C++

Продолжение примера: объявление и использование службы.

## Защита от dbus-monitor

Команда dbus-monitor используется для мониторинга сообщений, проходящих через шину сообщений D-Bus.
Чтобы защититься от мониторинга через dbus-monitor, следует выполнить действия:

1.	Передать дескриптор на pipe по D-Bus.
	(Нельзя перехватить такое действие через dbus-monitor)
2.	Общаться через pipe.

## Контроль подключений клиентов D-Bus

Чтобы контролировать клиентов, подключающихся в приложению по D-Bus, следует
воспользоваться службой ru.omp.am.Identify.

С её помощью можно идентифицировать клиента по уникальному D-Bus имени (начинается с “:”)
с помощью вызова Identify.
В ответ будет получен путь до вызывающего приложения и keyid.
keyid хранится в подписи исполняемого файла (security.ima xattr).
