# QObject, сигналы и слоты

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QObject

В основе объектной модели Qt лежит класс QObject.
QObject является единым базовым классом для большинства классов Qt. 
Ключевой особенностью объектной модели Qt является механизм общения между объектами,
называемый сигналы и слоты.
Данный механизм доступен для всех наследников класса QObject.

Классы, производные от QObject являются источником информации для системы мета-объектов.
Наличие макроса Q_OBJECT включает поддержку данной системы для объектов. 

Мета-объектный компилятор moc предоставляет каждому подклассу QObject код для реализации
мета-объектных возможностей.

## Расширение C++ классов

Для корректного функционирования системы объектов каждый наследник QObject должен содержать
в теле класса макрос Q_OBJECT. 
Важным ограничением Qt-объектов является запрет на копирование.
Наследники QObject не имеют конструктора копирования и оператора копирующего присваивания,
так что могут передаваться лишь по ссылке.
Информация о классе объекта может быть получена через систему метаобъектов.
Все объекты одного типа разделяют единый метаобъект с описанием их класса, который предоставляет
информацию об имени класса, реализуемых методах и свойствах.
Данная информация генерируется автоматически с помощью компилятора мета-объектов moc.

На слайде изображен простейший пример класса, наследуемого от QObject.
Класс имеет одно приватное поле, конструктор, один публичный метод, один слог и один сигнал.
Объявление класса описывается в .h-файле, реализация конструктора и методов — в .cpp-файле.

## Структура объявления класса

Структура объявления класса представлена на слайде.
Сначала указываются макросы, затем идут публичные и приватные блоки.
Для сигналов и слотов добавляются отдельные блоки.

## Сигналы и слоты

Взаимодействие объектов осуществляется с помощью механизма сигналов и слотов.
Сигналы, поддерживаемые объектом, объявляются в теле определения Qt-класса аналогично остальным методам.
Объявления сигналов размещаются в специальной секции signals.

Сигналы являются открытыми функциями, а их реализация генерируется компилятором метаобъектов.
Сигналы не должны возвращать каких-либо значений.
Рекомендуется предварять вызов сигнала словом emit, которое не имеет никакого функционального значения,
но делает код нагляднее.

Слоты объявляются так же как и обычные функции.
В отличие от сигналов, программист должен предоставить определения данных функций.
Объявления слотов располагаются в секции public slots.
Слоты могут использоваться как обычные функции.
На слайде приведен пример объявления сигнала textChanged() и слота printText(). 

## Подключение и испускание сигналов

Подключение слота к сигналу происходит с помощью метода connect() класса QObject.
Первый аргумент метода – указатель на объект-отправитель, который будет генерировать сигналы. 
Второй аргумент должен указывать на сигнал, для которого осуществляется подключение.
Сигнал оборачивается в макрос SIGNAL.
Третий аргумент – указатель на объект-получатель, слот которого будет вызван при обработке сигнала. 
Четвертый аргумент указывает на слот только теперь получателя.
Слот оборачивается в макрос SLOT.

На слайде два примера подключения сигнала к слоту. 
В первом создается объект и с помощью метода connect() его собственный сигнал соединяется с его собственным слотом. 
Во втором примере создаются два объекта.
Сигнал первого объекта соединяется со слотом второго.
Здесь приведены два эквивалентных описания соединения сигнала и слота.
В одном случае используется статическая функция connect(), где явно указываются все 4 аргумента. 
Во втором случае используется метод вызванный на объекте.
В этом случае не нужно указывать объект-получатель сигнала, т.к. на нем и вызывается метод connect().
Все остальные параметры описываются ровно так же.

Для отключения сигнала от слота используется QObject::disconnect().
Эта функция использует те же аргументы, что и connect().
На слайде изображены примеры отключения слотов от сигналов.
Здесь есть отключение всех объектов от всех сигналов объекта-отправителя.
Для этого необходимо в качестве всех аргументов, кроме первого указать нули. 
И эквивалентный вызов метода disconnect() на объекте отправителе сигналов, от которого нужно отключиться.
Далее описан вариант с отключением всех объектов от одного конкретного сигнала объекта-отправителя.
Здесь только последние два параметра указываются как 0, а объект-отправитель и его сигнал описываются.
И эквивалентный вызов метода disconnect() на объекте-отправителе с передаче в качестве аргумента
сигнал, от которого нужно отключиться.

А также пример с отключением объекта-получателя от всех сигналов объекта-отправителя.
В этом случае нули указываются на местах аргументов SIGNAL и SLOT.
И ниже эквивалентный вызов метода disconnect() на объекте-отправителе сигналов, куда в качестве
аргумента передается указатель на объект-получатель.

Отправка сигнала происходит с помощью ключевого слова emit. 
Для сигнала задается только прототип, причем сигнал не может возвращать значение (т.е., указывается void).
За реализацию отвечает компилятор метаобъектов.
