# Прокси-модели

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QAbstractProxyModel – базовый класс

Класс QAbstractProxyModel предоставляет базовый класс для моделей прокси-элементов, которые могут выполнять сортировку, фильтрацию и другие задачи обработки данных.

Этот класс определяет стандартный интерфейс, который прокси-модели должны использовать для корректного взаимодействия с другими компонентами модели/представления. Его экземпляр не должен создаваться напрямую.

Все стандартные прокси-модели являются производными от класса QAbstractProxyModel. Если вам нужно создать новый класс прокси-модели, обычно лучше создать подкласс существующего класса, который обеспечивает наиболее близкое к желаемому поведение.
Прокси-модели, которые фильтруют или сортируют элементы данных из исходной модели, следует создавать с помощью QSortFilterProxyModel.

Чтобы создать наследника QAbstractProxyModel, необходимо реализовать функции mapFromSource() и mapToSource().

## QSortFilterProxyModel – сортировка и фильтрация

Класс QSortFilterProxyModel обеспечивает поддержку сортировки и фильтрации данных, передаваемых между другой моделью и представлением.
QSortFilterProxyModel можно использовать для сортировки элементов, фильтрации элементов или для обоих этих целей. Модель преобразует структуру исходной модели, сопоставляя предоставляемые ею индексы модели с новыми индексами, соответствующими различным расположениям, используемыми представлениями. Такой подход позволяет реструктурировать исходную модель с точки зрения представлений, не требуя никаких преобразований базовых данных и не дублируя данные в памяти.

Метод sort() сортирует модель по столбцам в заданном порядке.

setFilterKeyColumn() — столбец, из которого считывается ключ, используемый для фильтрации содержимого исходной модели.
setFilterRegExp() — регулярное выражение для фильтрации содержимого исходной модели.

## Пример QSortFilterProxyModel

Предположим, что нужно сортировать и фильтровать элементы, предоставляемые пользовательской моделью.
Чтобы добавить поддержку сортировки и фильтрации в MyItemModel, необходимо создать QSortFilterProxyModel, вызвать setSourceModel() с MyItemModel в качестве аргумента и установить QSortFilterProxyModel в представлении.

Помимо сортировки, QSortFilterProxyModel можно использовать для скрытия элементов, не соответствующих определённому фильтру. Фильтр задаётся с помощью объекта QRegExp и применяется к функции filterRole() (по умолчанию Qt::DisplayRole) каждого элемента для заданного столбца. Объект QRegExp можно использовать для сопоставления с регулярным выражением, подстановочным шаблоном или фиксированной строкой.
