# QAbstractListModel

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Модель списка на C++

Класс QAbstractListModel предоставляет абстрактную модель, которая может быть разделена
на подклассы для создания моделей одномерного списка.

QAbstractListModel предоставляет стандартный интерфейс для моделей, которые представляют
свои данные в виде простой неиерархической последовательности элементов.
Он не используется напрямую, но может быть унаследован.

Если ваша модель используется в QML и требует ролей, отличных от ролей по умолчанию,
предоставляемых функцией roleNames(), вы должны переопределить ее.

Для редактируемых моделей списков вы также должны предоставить реализацию setData()
и реализовать функцию flags(), чтобы она возвращала значение, содержащее Qt::ItemIsEditable.

Обратите внимание, что QAbstractListModel предоставляет реализацию columnCount() по умолчанию,
которая сообщает представлениям, что в этой модели есть только один столбец элементов.

Модели, которые предоставляют интерфейсы структурам данных с изменяемым размером списка,
могут предоставлять реализации insertRows() и removeRows().
При реализации этих функций важно вызывать соответствующие функции, чтобы все связанные
представления знали о любых изменениях:

Реализация insertRows() должна вызывать beginInsertRows() перед вставкой новых строк в структуру
данных, и она должна вызывать endInsertRows() сразу после этого.

Реализация removeRows() должна вызывать beginRemoveRows(), прежде чем строки будут удалены
из структуры данных, и должна вызывать endRemoveRows() сразу после этого.

Если модель должна быть доступной в QML-коде, зарегистрируйте её класс.

## Пример QAbstractListModel [1]

Простые модели могут быть созданы путем создания подклассов этого класса и реализации
минимального количества необходимых функций.
Например, мы реализуем простую модель DemoModel для работы с QStringList.

Для чтения данных нам нужно реализовать функцию rowCount(), чтобы вернуть количество элементов
в списке, и функцию data(), чтобы получить элементы из списка.
Поскольку модель представляет одномерную структуру, функция rowCount() возвращает общее количество
элементов в модели.
 
Кроме того, у модели будет дополнительная роль NameRole, кроме роли UserRole, имеющейся по умолчанию.

## Пример QAbstractListModel [2]

В конструкторе модель заполняется списком констант.

В переопределенном методе roleNames, который возвращает список ролей, дополнительно
добавляется роль NameRole.

Метод data возвращает данные по индексу, если роль указана верно.

## Пример QAbstractListModel [3]

Метод activate перемещает элемент с индексом i в начало списка: сохраняет i-ый элемент,
сдвигает строки вниз, добавляет сохраненный элемент в начало.

Обратите внимание, что перед и после сдвига элементов массива, а также перед и после записи
нового первого элемента, вызываются специальные методы родителя beginRemoveRows, endRemoveRows,
beginInsertRows, endInsertRows.
