# C++ API для базы данных

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Доступ к базам данных через C++

В случае, если работа с базами данных требует расширенного взаимодействия, следует обратиться к С++ классам. 

Работа с базами данных в Qt на языке С++ происходит на различных уровнях:

Первый слой драйверов, который предоставляет низкоуровневый мост между определенными базами данных
и слоем SQL API.
В Qt включены драйвера нескольких баз данных, среди них MySQL, PostgreSQL, InterBase и другие. 

Слой SQL API предоставляет доступ к базам данных.
Соединения устанавливаются с помощью класса QSqlDatabase, а взаимодействие с базой данных
осуществляется с помощью класса QSqlQuery.

Слой пользовательского интерфейса связывает данные из базы с дата-ориентированными виджетами. 

## Работа с базой данных в С++

Чтобы использовать SQL в C++, в .pro-файле приложения нужно подключить модуль sql в секции Qt.
А затем включить sql в С++-файлах. 

 Чтобы получить доступ к базе данных, необходимо создать и открыть одно или несколько
 соединений с базой данных.
 Соединения с базой данных обычно идентифицируются по имени соединения, а не по имени базы данных.
 К одной базе данных может быть несколько соединений.
 QSqlDatabase также поддерживает концепцию соединения по умолчанию, которое является
 неназванным соединением.
 При вызове методов QSqlQuery или QSqlQueryModel, которые принимают аргумент имени соединения,
 если вы не передаете имя соединения, будет использоваться соединение по умолчанию.
 Создание соединения по умолчанию удобно, когда вашему приложению требуется только
 одно соединение с базой данных.

Обратите внимание на разницу между созданием соединения и его открытием.
Создание соединения включает в себя создание экземпляра класса QSqlDatabase.
Соединение невозможно использовать, пока оно не открыто.
В примере на слайде показано, как создать подключение по умолчанию, а затем открыть его.

Первая строка создает объект подключения, а последняя строка открывает его для использования.
В промежутке мы инициализируем некоторую информацию о соединении, включая имя базы данных,
имя хоста, имя пользователя и пароль.
Аргумент «QMYSQL» для метода addDatabase() указывает тип драйвера базы данных, который будет
использоваться для соединения.

## QSqlQuery

Класс QSqlQuery обеспечивает интерфейс для выполнения SQL запросов и навигации по результирующей выборке.
Чтобы выполнить SQL запрос, создаем объект QSqlQuery и вызываем метод QSqlQuery::exec(),
сам запрос передаем в аргументе. 

QSqlQuery предоставляет доступ к результирующему набору по одной записи за раз.
После вызова exec() внутренний указатель QSqlQuery находится на позиции перед первой записью.
Мы должны вызвать метод next () один раз, чтобы перейти к первой записи, затем next() снова и снова,
чтобы получить доступ к другим записям, пока он не вернет false.
На слайде представлен цикл, который перебирает все записи по порядку.

Функция value возвращает значение поля в текущей записи.
Поля указываются в виде индексов, начинающихся с 0. value возвращает QVariant.
Во фрагменте кода мы вызываем методы toString () и toInt() для преобразования в строку
или число соответственно. 

QSqlQuery позволяет выполнять разлчиные SQL запросы. 

## Запрос INSERT

В следующем примере вставляется запись в таблицу с использованием INSERT.

Если вы хотите вставить много записей одновременно, зачастую более эффективно отделить запрос
от вставляемых фактических значений. Это можно сделать с помощью заполнителей.
Qt поддерживает два синтаксиса-заполнителя: именованное связывание и позиционное связывание.
На слайде пример позиционного связывания.

Оба синтаксиса работают со всеми драйверами базы данных, предоставляемыми Qt.
Если база данных изначально поддерживает синтаксис, Qt просто перенаправляет запрос в СУБД;
в противном случае Qt имитирует синтаксис заполнителя путем предварительной обработки запроса.
Фактический запрос, который завершается выполнением СУБД, доступен с помощью метода executeQuery().

При вставке нескольких записей необходимо вызвать метод prepare() только один раз.
Затем вызывается метод bindValue() или addBindValue(), а затем exec() столько раз, сколько необходимо.

Помимо производительности, одним из преимуществ заполнителей является то, что вы можете легко
указывать произвольные значения, не беспокоясь о экранировании специальных символов.
