# Система сборки CMake

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Система CMake

CMake - это инструмент, упрощающий процесс сборки для проектов разработки на разных платформах.
CMake формирует состав компонентов и файлов, входящих в проект, необходимых для создания приложения.

С Qt 5 можно использовать версии CMake до 3.1.0 включительно.

CMake автоматизирует настройку систем сборки. Он контролирует процесс компиляции программного
обеспечения с помощью простых файлов конфигурации, называемых файлами CMakeLists.txt.
CMake генерирует собственные конфигурации сборки и рабочие области, которые можно использовать
в среде компилятора по вашему выбору.

Qt Creator автоматически запускает CMake для обновления информации о проекте, когда вы редактируете
файл конфигурации CMakeLists.txt в проекте.
Информация о проекте также автоматически обновляется при сборке проекта.

## Пример CMakeLists.txt

Пример CMakeLists.txt для ОС Аврора.

В примере на слайде пропущено несколько строчек с функциями install, которые отвечают за установку
ресурсов приложения: файлов qml, переводов и т.п. в конкретные директории в ОС Аврора.
С полным кодом примера можно познакомиться самостоятельно, создав новый проект в Аврора IDE.

## CMakeLists.txt

В project указывется имя проекта, например, my_cmake_project.

cmake_minimum_required указывает необходимую минимальную версию cmake.

Одной из основных функций является `find_package`.
Она позволяет найти библиотеки и файлы заголовков, поставляемые с Qt.
Затем вы можете использовать эти библиотеки и файлы заголовков с командой `target_link_libraries`
для создания библиотек и приложений на основе Qt.

pkg_search_module использует инструмент pkg-config для определения местоположения запрошенной библиотеки.
В данном случае это библиотека auroraapp, необходимая Аврора-приложениям.

Параметр CMAKE_AUTOMOC запускает компилятор moc автоматически при необходимости.

Параметр add_executable указывает на заголовочные и cpp-файлы проекта.
Параметр add_custom_target - на другие файлы проекта.

Параметр files сообщает IDE, где исполняемые файлы приложения будут расположены на устройстве.
