# Camera – настройка, получение информации о доступных камерах

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Camera — получение изображений и видео

Тип Camera используется для захвата изображений и видеороликов с камеры, а также
для управления настройками захвата и обработки, которые применяются к изображениям.
Для отображения видоискателя обычно используется компонент VideoOutput, где в качестве источника
установлена камера. 

Настроить камеру на фото или видеосъемку можно с помощью свойства captureMode.
Используемое устройство, например обычная или фронтальная камера, указывается в свойстве deviceId,
мета-данные о снимке или видео сохраняются в наборе свойств metaDatа. 

Также можно узнать текущее состояние камеры, а также статус фокусировки на конкретном объекте.
Для старта фокусировки необходимо вызвать метод SearchAndLock.
Кроме фокуса данный метод также начинает настройку экспозиии и баланса белого.
Это целесообразно для вызова при нажатии кнопки фокусировки камеры.
Если камера поддерживает автофокусировку, информация о зонах фокусировки доступна
через свойство focus.

Различные настройки и функциональные возможности стека камеры распространяются
на несколько разных дочерних свойств типа Camera.

*	imageCapture - методы и свойства для захвата неподвижных изображений.
*	videoRecording - для захвата видео.
*	exposure содержит методы и свойства для регулировки экспозиции
	(диафрагма, выдержка затвора и т. д.), focus - для корректировки фокуса и информации об автофокусе,
	а flash - для управления вспышкой камеры.

## Доступные камеры

Объект QtMultimedia — это глобальный объект со служебными функциями и свойствами.

Он не может быть создан; для его использования необходимо напрямую вызывать элементы глобального объекта QtMultimedia.

availableCameras : list<object> предоставляет информацию о камерах, доступных в системе.

Каждый объект в списке имеет следующие свойства:

*	deviceId — уникальный идентификатор камеры.
	Вы можете выбрать устройство для использования с объектом Camera, установив это значение в его свойстве deviceId.
*	displayName — понятное для человека имя камеры.
	Это свойство можно использовать для отображения имени камеры в пользовательском интерфейсе.
*	position — физическое положение камеры в системе.
*	orientation — физическая ориентация сенсора камеры.

defaultCamera : object
Объект defaultCamera предоставляет информацию о камере по умолчанию в системе.
Его свойства: deviceId, displayName, position и orientation.
Если камера по умолчанию отсутствует, defaultCamera.deviceId будет содержать пустую строку.
