# Фоновые задачи

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Фоновые задачи для приложений

Фоновые задачи позволяют выполнять дополнительные процессы в фоновом режиме, не замедляя основную работу системы. Это может быть полезно, например, для выполнения резервного копирования данных, обновления программного обеспечения, мониторинга состояния аппаратуры и других задач, которые требуют непрерывного выполнения.

Фоновые задачи делятся на следующие типы:

*	периодические задачи — запускаются RuntimeManager с интервалами, определёнными приложением;
*	запланированные задачи — запускаются RuntimeManager в определённое приложением время;
*	управляемая событиями задача — задача будет запущена RuntimeManager при выполнении определённых условий. Если условия больше не выполняются, задача может быть остановлена или заморожена;
*	рабочая задача — запускается по явному запросу приложения.

## Конфигурация в desktop-файле

Приложения, использующие фоновые задачи, требуют их описания в desktop-файле. Описание должно содержать тип и параметры, если требуется, для каждого типа создаваемых фоновых задач. Запуск второго экземпляра фоновой задачи того же типа независимо от значения в desktop-файле невозможен.

Строка MimeType позволяет дополнительно добавлять обработчики для доменов у приложений.
Например, данное поле позволяет добавить приложение как обработчик домена qr.nspk.ru.
Тогда при переходе в браузере на https://qr.nspk.ru пользователю будет предложено перейти в приложение, 
которое зарегистрировало себя как обработчик данного домена (предполагается, что приложение,
добавляя такой обработчик, действительно знает, как обрабатывать данный домен). 
Данный механизм работает для всех доменов.

В более общем случае поле MimeType может быть использовано, когда приложение регистрирует себя обработчиком
одного типа файлов, например image/jpeg.
Строка Exec может быть опущена, и в этом случае будет запущен тот же исполняемый файл, что и приложение.

Строка разрешений может быть опущена, и в этом случае задача будет иметь только базовый профиль задачи.

## Периодические задачи

Периодические задачи используются для выполнения короткой работы через определенные промежутки времени.
Параметры передаются во время выполнения приложения. В desktop-файле их задать нельзя.

В desktop-файле должны быть указаны максимальные временные рамки, в течение которых задача будет выполняться, но расписание также может быть скорректировано приложением или самой задачей при условии, что указанное расписание не должно предоставлять процессу более широкий график, чем тот, который указан в desktop-файле (это позволяет менеджеру пакетов проверить desktop-файл на предмет злоупотреблений и может быть использовано для того, чтобы дать пользователю представление о том, насколько ресурсоёмкой является задача).

Задача не должна делать никаких предположений о механизме, который будет использоваться для её запуска: это может быть то, что процесс прерывается и перезапускается при каждом "тике" расписания, или что один и тот же процесс замораживается/размораживается в соответствии с расписанием.

## Условия фоновой задачи

Разработчики приложений могут добавить строку "Conditions" в свой файл desktop, чтобы указать, что задача должна выполняться только при определённых условиях.

Двоеточие можно использовать для указания дополнительного условия, например "internet:wifi"

Условие AND-ed (&&) используется для комбинирования двух или более условий и означает, что задача будет выполнена только при соблюдении всех условий.

Можно указать условия, препятствующие запуску задачи, когда она не сможет выполнить свою работу.

Список поддерживаемых условий:

*	internet — выполняется при наличии подключения к Интернету. Доступны следующие дополнительные условия:
	*	Wi-Fi — подключение осуществляется по сети Wi-Fi;
	*	ethernet — подключение осуществляется через адаптер ethernet;
	*	wifi-or-ethernet;
	*	cellular — подключение осуществляется по сети сотовой связи;
*	idle — значение true, когда устройство находится в режиме ожидания (пользователь не использует его активно);
*	charging — значение true, когда устройство заряжается;
*	battery-not-low — батарея не разряжена.

## Схемы URI

Нет никаких ограничений на то, какие URI могут быть отправлены в уведомлении, при условии, что их размер не превышает 2048 байт.

С другой стороны, приложения, желающие обрабатывать уведомления, могут зарегистрироваться в качестве обработчиков только для следующих схем URI:

*	любой схемы, одобренной IANA, со статусом "постоянный" или "временный";
*	любой схемы, начинающейся с "aurora-<название_организации>.". Это позволяет приложениям определять свою собственную схему, гарантируя при этом отсутствие конфликтов с другими приложениями.

## Доступные методы IPC

Приложение может взаимодействовать со своей фоновой задачей с помощью следующих методов IPC:

*	обычные файлы, поскольку приложение и задача совместно используют общий вид файловой системы;
*	сокеты с поддержкой файлов. Рекомендуется, чтобы сокет обслуживался фоновой задачей, поскольку приложение может быть закрыто/заморожено в любой момент;
*	разделяемая память (в POSIX, то есть shm_open() и friends), но только в том случае, если имя области SHM начинается с идентификатора приложения;
*	безымянные семафоры (sem_init());
*	именованные семафоры, если их название начинается с идентификатора приложения;
*	D-Bus: фоновые задачи могут вызывать методы в приложении (приложение регистрирует применяемые методы как имя службы). Важно, что вызов методов не приведёт к автоматическому запуску приложения, если оно не запущено.

## Библиотека и API

Runtime manager предоставляет библиотеку, чтобы запускать интенты и фоновые задачи:

*	чтобы запускать фоновые задачи, используется класс Task:
*	для периодических задач есть класс Schedule, через который описывается расписание;
*	если разработчик хочет использовать один и тот же бинарный файл и для приложения, и для фоновой задачи, методы onApplicationStarted и onTaskStarted в классе RuntimeDispatcher помогают определить, если программа запускалась как приложение или как фоновая задача.

## Управление фоновой задачей

Фрагмент кода на слайде иллюстрирует создание и управление задачей в фоновом режиме.

## Управление фоновой задачей [2]

Фрагмент кода на слайде продолжает предыдущий пример и иллюстрирует отображение QML-интерфейса с помощью RuntimeDispatcher.
