# Задания по теме «Запись звука»

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Подготовка

В раздел Requires файла multimedia.spec добавить общие зависимости для проигрывания и записи
мультимедиа и для использования мультимедиа в QML.

## Работа с диктофоном

Доработать компонент DictaphonePage для записи и воспроизведения аудиофайлов.

1.	В раздел Requires файла media.spec и в файл media.pro добавить зависимости
	для использования мультимедиа в С++.
2.	Создать класс AudioRecorder, унаследованный от QAudioRecorder.
3.	В конструкторе класса AudioRecorder реализовать настройку кодека записываемого аудиофайла:

```cpp
QAudioEncoderSettings audioSettings;
audioSettings.setCodec("audio/PCM");
audioSettings.setQuality(QMultimedia::HighQuality);
this->setEncodingSettings(audioSettings);
this->setContainerFormat("wav");
```

4.	Зарегистрировать класс AudioRecorder в QML-модуле Multimedia версии 1.0.
5.	В элемент buttonsRow добавить кнопки для запуска, паузы и завершения записи в элементе audioRecorder.
	Использовать соответствующие системные иконки: icon-m-call-recording-on, icon-m-pause, icon-m-call-recording-off.
6.	В элемент buttonsRow добавить кнопки для запуска, паузы и завершения проигрывания в элементе audioPlayer.
	Использовать соответствующие системные иконки: icon-m-play, icon-m-pause, icon-m-clear.
7.	Настроить видимость добавленных кнопок:

*	При открытии страницы должны быть видимы только кнопки запуска записи и проигрывания.
*	При активной записи должны быть видимы только кнопки паузы и завершения записи.
*	При приостановленной записи должны быть видимы только кнопки запуска и завершения записи.
*	При активном проигрывании должны быть видимы только кнопки паузы и завершения проигрывания.
*	При приостановленном проигрывании должны быть видимы только кнопки запуска и завершения проигрывания.

Для получения состояний элементов audioRecorder и audioPlayer использовать соответственно свойства
state и playbackState.

8.	Добавить обработчик сигнала stateChanged элемента audioRecorder так, чтобы при завершении
	записи происходила перезагрузка элемента audioPlayer:

```qml
audioPlayer.source = "";
audioPlayer.source = filePath;
```

9.	В элементе recordInfo сделать отображение записанного времени в секундах.
	Важно иметь в виду, что если элемент audioRecorder не вызывался для записи, то время нужно
	брать из элемента audioPlayer.
10.	В элементе playInfo сделать отображение текущей позиции проигрывания в секундах.
