# Состояния приложения

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Состояния приложения в Qt

QGuiApplication позволяет отслеживать состояния приложения.

Перечисление Qt::ApplicationState используется для указания текущего состояния приложения.

Состояния:

*	Qt::ApplicationSuspended – Приложение готовится к приостановке. При переходе в это состояние приложение должно сохранить своё состояние, прекратить все действия и быть готовым к остановке выполнения кода. В состоянии приостановки приложение может быть завершено в любой момент без дальнейших предупреждений (например, когда из-за нехватки памяти ОС вынуждена очистить приостановленные приложения).
*	Qt::ApplicationHidden – Приложение скрыто и работает в фоновом режиме. Это нормальное состояние для приложений, которым необходимо выполнять фоновые процессы, например, воспроизводить музыку, пока пользователь взаимодействует с другими приложениями. При переходе в это состояние приложение должно освободить все графические ресурсы.
*	Qt::ApplicationInactive – Приложение видимо, но не выбрано для размещения на переднем плане. На мобильных платформах это состояние чаще возникает, когда ОС отвлекает пользователя, например, входящими звонками или SMS-сообщениями. В этом состоянии рекомендуется сократить количество задач, интенсивно использующих процессор.
*	Qt::ApplicationActive – Приложение отображается и выбрано на переднем плане.

Метод applicationState() возвращает текущее состояние приложения.
Можно реагировать на изменения состояния приложения, выполняя такие действия, как остановка/возобновление ресурсоёмких задач, освобождение/загрузка ресурсов или сохранение/восстановление данных приложения.

Сигнал applicationStateChanged() испускается при изменении состояния приложения.

## Состояния приложения в ОС Аврора

RuntimeManager — это компонент в ОС Аврора, который отвечает за управление временем жизни приложения и фоновых задач. Он содержит набор функций для управления жизненным циклом приложения, включая запуск и остановку выполнения программы.

Через RuntimeManager приложение имеет возможность создавать фоновые задачи, независимые от жизненного цикла приложения. Он также предоставляет механизмы взаимодействия приложений, например, интенты или обработка URI.

Также RuntimeManager обеспечивает возможность клиентам отслеживать жизненный цикл приложений и сервисов в среде выполнения.

Для поддержки запуска нескольких экземпляров приложения RuntimeManager использует понятие "ID экземпляра приложения", который представляет собой ID приложения. ID приложения должен быть уникальным для всех экземпляров данного приложения.

## Переменные окружения RuntimeManager

*	AURORA_APP_ID — содержит идентификатор (<org-name>.<app_name>) текущего приложения.
*	AURORA_TASK_ID — идентификатор фоновой задачи. Если один и тот же двоичный файл используется как для приложения, так и для его фоновых задач, эту переменную можно использовать, чтобы понять, в каком режиме выполняется процесс.
*	AURORA_TASK_FD — файловый дескриптор сокета-прослушивателя. Приложение или другие фоновые задачи могут подключаться к этому сокету для обмена данными.
*	AURORA_APP_INSTANCE_ID — содержит идентификатор приложения в сочетании с числовым идентификатором экземпляра (<org-name>.<app_name>.<instance_id>), где значение instance_id формируется как instance_<уникальное число>, для приложений с несколькими экземплярами; для приложений с одним экземпляром это будет то же самое, что и AURORA_APP_ID. Только в некоторых случаях может понадобиться передать AURORA_APP_INSTANCE_ID экземпляра приложения, которое вручную запросило задание.
